/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import software.amazon.lambda.powertools.logging.internal.DefaultLoggingManager;
import software.amazon.lambda.powertools.logging.internal.LoggingManager;

public final class LoggingManagerRegistry {
    private static volatile LoggingManager instance;

    private LoggingManagerRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoggingManager getLoggingManager() {
        LoggingManager manager = instance;
        if (manager != null) return manager;
        Class<LoggingManagerRegistry> clazz = LoggingManagerRegistry.class;
        synchronized (LoggingManagerRegistry.class) {
            manager = instance;
            if (manager != null) return manager;
            instance = manager = LoggingManagerRegistry.loadLoggingManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return manager;
        }
    }

    private static LoggingManager loadLoggingManager() {
        ServiceLoader loggingManagers;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            loggingManagers = ServiceLoader.load(LoggingManager.class);
        } else {
            PrivilegedAction<ServiceLoader> action = () -> ServiceLoader.load(LoggingManager.class);
            loggingManagers = AccessController.doPrivileged(action);
        }
        ArrayList<LoggingManager> loggingManagerList = new ArrayList<LoggingManager>();
        for (LoggingManager lm : loggingManagers) {
            loggingManagerList.add(lm);
        }
        return LoggingManagerRegistry.selectLoggingManager(loggingManagerList, System.err);
    }

    static LoggingManager selectLoggingManager(List<LoggingManager> loggingManagerList, PrintStream printStream) {
        LoggingManager loggingManager;
        if (loggingManagerList.isEmpty()) {
            printStream.println("ERROR. No LoggingManager was found on the classpath");
            printStream.println("ERROR. Applying default LoggingManager: POWERTOOLS_LOG_LEVEL variable is ignored");
            printStream.println("ERROR. Make sure to add either powertools-logging-log4j or powertools-logging-logback to your dependencies");
            loggingManager = new DefaultLoggingManager();
        } else {
            if (loggingManagerList.size() > 1) {
                printStream.println("WARN. Multiple LoggingManagers were found on the classpath");
                for (LoggingManager manager : loggingManagerList) {
                    printStream.println("WARN. Found LoggingManager: [" + manager + "]");
                }
                printStream.println("WARN. Make sure to have only one of powertools-logging-log4j OR powertools-logging-logback in your dependencies");
                printStream.println("WARN. Using the first LoggingManager found on the classpath: [" + loggingManagerList.get(0) + "]");
            }
            loggingManager = loggingManagerList.get(0);
        }
        return loggingManager;
    }
}

