/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import software.amazon.lambda.powertools.utilities.JsonConfig;

public class JsonSerializer
implements AutoCloseable {
    private final StringBuilder builder;

    public JsonSerializer(StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("StringBuilder cannot be null");
        }
        this.builder = builder;
    }

    public void writeStartArray() {
        this.builder.append('[');
    }

    public void writeEndArray() {
        this.builder.append(']');
    }

    public void writeStartObject() {
        this.builder.append('{');
    }

    public void writeEndObject() {
        this.builder.append('}');
    }

    public void writeSeparator() {
        this.writeRaw(',');
    }

    public void writeFieldName(String name) {
        Objects.requireNonNull(name, "field name must not be null");
        this.writeString(name);
        this.writeRaw(':');
    }

    public void writeString(String text) {
        if (text == null) {
            this.writeNull();
        } else {
            this.builder.append("\"").append(text.replace("\"", "\\\"")).append("\"");
        }
    }

    public void writeRaw(String text) {
        this.builder.append(text);
    }

    public void writeRaw(char c) {
        this.builder.append(c);
    }

    public void writeNumber(short v) {
        this.builder.append(v);
    }

    public void writeNumber(int v) {
        this.builder.append(v);
    }

    public void writeNumber(long v) {
        this.builder.append(v);
    }

    public void writeNumber(BigInteger v) {
        this.builder.append(v);
    }

    public void writeNumber(double v) {
        this.builder.append(v);
    }

    public void writeNumber(float v) {
        this.builder.append(v);
    }

    public void writeNumber(BigDecimal v) {
        this.builder.append(v.toPlainString());
    }

    public void writeBoolean(boolean state) {
        this.builder.append(state);
    }

    public void writeArray(char[] items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.length) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                this.builder.append('\'');
                this.builder.append(items[itemIndex]);
                this.builder.append('\'');
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeArray(boolean[] items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.length) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                boolean item = items[itemIndex];
                this.writeBoolean(item);
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeArray(byte[] items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.length) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                byte item = items[itemIndex];
                this.writeNumber(item);
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeArray(short[] items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.length) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                short item = items[itemIndex];
                this.writeNumber(item);
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeArray(int[] items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.length) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                int item = items[itemIndex];
                this.writeNumber(item);
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeArray(long[] items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.length) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                long item = items[itemIndex];
                this.writeNumber(item);
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeArray(float[] items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.length) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                float item = items[itemIndex];
                this.writeNumber(item);
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeArray(double[] items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.length) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                double item = items[itemIndex];
                this.writeNumber(item);
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeArray(Object[] items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.length) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                Object item = items[itemIndex];
                this.writeObject(item);
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeNull() {
        this.builder.append("null");
    }

    public void writeArray(List<?> items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            int itemIndex = 0;
            while (itemIndex < items.size()) {
                if (itemIndex > 0) {
                    this.writeSeparator();
                }
                Object item = items.get(itemIndex);
                this.writeObject(item);
                ++itemIndex;
            }
            this.writeEndArray();
        }
    }

    public void writeArray(Collection<?> items) {
        if (items == null) {
            this.writeNull();
        } else {
            this.writeStartArray();
            Iterator<?> iterator = items.iterator();
            while (iterator.hasNext()) {
                this.writeObject(iterator.next());
                if (!iterator.hasNext()) continue;
                this.writeSeparator();
            }
            this.writeEndArray();
        }
    }

    public void writeMap(Map<?, ?> map) {
        if (map == null) {
            this.writeNull();
        } else {
            this.writeStartObject();
            Iterator<Map.Entry<?, ?>> entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<?, ?> entry = entries.next();
                this.writeObjectField(String.valueOf(entry.getKey()), entry.getValue());
                if (!entries.hasNext()) continue;
                this.builder.append(',');
            }
            this.writeEndObject();
        }
    }

    public void writeObject(Object value) {
        block39: {
            block56: {
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    block50: {
                                        block49: {
                                            block48: {
                                                block47: {
                                                    block46: {
                                                        block45: {
                                                            block44: {
                                                                block43: {
                                                                    block42: {
                                                                        block41: {
                                                                            block40: {
                                                                                block38: {
                                                                                    if (value != null) break block38;
                                                                                    this.writeNull();
                                                                                    break block39;
                                                                                }
                                                                                if (!(value instanceof String)) break block40;
                                                                                this.writeString((String)value);
                                                                                break block39;
                                                                            }
                                                                            if (!(value instanceof Number)) break block41;
                                                                            Number n = (Number)value;
                                                                            if (n instanceof Integer) {
                                                                                this.writeNumber(n.intValue());
                                                                            } else if (n instanceof Long) {
                                                                                this.writeNumber(n.longValue());
                                                                            } else if (n instanceof Double) {
                                                                                this.writeNumber(n.doubleValue());
                                                                            } else if (n instanceof Float) {
                                                                                this.writeNumber(n.floatValue());
                                                                            } else if (n instanceof Short) {
                                                                                this.writeNumber(n.shortValue());
                                                                            } else if (n instanceof Byte) {
                                                                                this.writeNumber(n.byteValue());
                                                                            } else if (n instanceof BigInteger) {
                                                                                this.writeNumber((BigInteger)n);
                                                                            } else if (n instanceof BigDecimal) {
                                                                                this.writeNumber((BigDecimal)n);
                                                                            } else if (n instanceof AtomicInteger) {
                                                                                this.writeNumber(((AtomicInteger)n).get());
                                                                            } else if (n instanceof AtomicLong) {
                                                                                this.writeNumber(((AtomicLong)n).get());
                                                                            }
                                                                            break block39;
                                                                        }
                                                                        if (!(value instanceof Boolean)) break block42;
                                                                        this.writeBoolean((Boolean)value);
                                                                        break block39;
                                                                    }
                                                                    if (!(value instanceof AtomicBoolean)) break block43;
                                                                    this.writeBoolean(((AtomicBoolean)value).get());
                                                                    break block39;
                                                                }
                                                                if (!(value instanceof List)) break block44;
                                                                List list = (List)value;
                                                                this.writeArray(list);
                                                                break block39;
                                                            }
                                                            if (!(value instanceof Collection)) break block45;
                                                            Collection collection = (Collection)value;
                                                            this.writeArray(collection);
                                                            break block39;
                                                        }
                                                        if (!(value instanceof Map)) break block46;
                                                        Map map = (Map)value;
                                                        this.writeMap(map);
                                                        break block39;
                                                    }
                                                    if (!(value instanceof char[])) break block47;
                                                    char[] charValues = (char[])value;
                                                    this.writeArray(charValues);
                                                    break block39;
                                                }
                                                if (!(value instanceof boolean[])) break block48;
                                                boolean[] booleanValues = (boolean[])value;
                                                this.writeArray(booleanValues);
                                                break block39;
                                            }
                                            if (!(value instanceof byte[])) break block49;
                                            byte[] byteValues = (byte[])value;
                                            this.writeArray(byteValues);
                                            break block39;
                                        }
                                        if (!(value instanceof short[])) break block50;
                                        short[] shortValues = (short[])value;
                                        this.writeArray(shortValues);
                                        break block39;
                                    }
                                    if (!(value instanceof int[])) break block51;
                                    int[] intValues = (int[])value;
                                    this.writeArray(intValues);
                                    break block39;
                                }
                                if (!(value instanceof long[])) break block52;
                                long[] longValues = (long[])value;
                                this.writeArray(longValues);
                                break block39;
                            }
                            if (!(value instanceof float[])) break block53;
                            float[] floatValues = (float[])value;
                            this.writeArray(floatValues);
                            break block39;
                        }
                        if (!(value instanceof double[])) break block54;
                        double[] doubleValues = (double[])value;
                        this.writeArray(doubleValues);
                        break block39;
                    }
                    if (!(value instanceof Object[])) break block55;
                    Object[] values = (Object[])value;
                    this.writeArray(values);
                    break block39;
                }
                if (!(value instanceof JsonNode)) break block56;
                JsonNode node = (JsonNode)value;
                switch (node.getNodeType()) {
                    case MISSING: 
                    case NULL: {
                        this.writeNull();
                        break;
                    }
                    case STRING: {
                        this.writeString(node.asText());
                        break;
                    }
                    case BOOLEAN: {
                        this.writeBoolean(node.asBoolean());
                        break;
                    }
                    case NUMBER: {
                        if (node.isInt()) {
                            this.writeNumber(node.intValue());
                            break;
                        }
                        if (node.isLong()) {
                            this.writeNumber(node.longValue());
                            break;
                        }
                        if (node.isShort()) {
                            this.writeNumber(node.shortValue());
                            break;
                        }
                        if (node.isDouble()) {
                            this.writeNumber(node.doubleValue());
                            break;
                        }
                        if (node.isFloat()) {
                            this.writeNumber(node.floatValue());
                            break;
                        }
                        if (node.isBigDecimal()) {
                            this.writeNumber(node.decimalValue());
                            break;
                        }
                        if (node.isBigInteger()) {
                            this.writeNumber(node.bigIntegerValue());
                            break;
                        }
                        break block39;
                    }
                    case OBJECT: 
                    case POJO: {
                        this.writeStartObject();
                        Iterator entries = node.fields();
                        while (entries.hasNext()) {
                            Map.Entry entry = (Map.Entry)entries.next();
                            this.writeObjectField((String)entry.getKey(), entry.getValue());
                            if (!entries.hasNext()) continue;
                            this.builder.append(',');
                        }
                        this.writeEndObject();
                        return;
                    }
                    case ARRAY: {
                        ArrayNode arrayNode = (ArrayNode)node;
                        this.writeStartArray();
                        Iterator elements = arrayNode.elements();
                        while (elements.hasNext()) {
                            this.writeObject(elements.next());
                            if (!elements.hasNext()) continue;
                            this.builder.append(',');
                        }
                        this.writeEndArray();
                        return;
                    }
                }
                break block39;
            }
            try {
                this.writeRaw(JsonConfig.get().getObjectMapper().writeValueAsString(value));
            }
            catch (Exception exception) {
                this.writeString(value.toString());
            }
        }
    }

    public void writeObjectField(String key, Object value) {
        this.writeFieldName(key);
        this.writeObject(value);
    }

    public void writeBooleanField(String key, boolean value) {
        this.writeFieldName(key);
        this.writeBoolean(value);
    }

    public void writeNullField(String key) {
        this.writeFieldName(key);
        this.writeNull();
    }

    public void writeNumberField(String key, int value) {
        this.writeFieldName(key);
        this.writeNumber(value);
    }

    public void writeNumberField(String key, float value) {
        this.writeFieldName(key);
        this.writeNumber(value);
    }

    public void writeNumberField(String key, short value) {
        this.writeFieldName(key);
        this.writeNumber(value);
    }

    public void writeNumberField(String key, long value) {
        this.writeFieldName(key);
        this.writeNumber(value);
    }

    public void writeNumberField(String key, BigInteger value) {
        this.writeFieldName(key);
        this.writeNumber(value);
    }

    public void writeNumberField(String key, double value) {
        this.writeFieldName(key);
        this.writeNumber(value);
    }

    public void writeNumberField(String key, BigDecimal value) {
        this.writeFieldName(key);
        this.writeNumber(value);
    }

    public void writeStringField(String key, String value) {
        this.writeFieldName(key);
        this.writeString(value);
    }

    public void writeTree(TreeNode rootNode) {
        if (rootNode == null) {
            this.writeNull();
        } else if (rootNode instanceof TextNode) {
            this.writeString(((TextNode)rootNode).asText());
        } else if (rootNode instanceof BooleanNode) {
            this.writeBoolean(((BooleanNode)rootNode).asBoolean());
        } else if (rootNode instanceof NumericNode) {
            NumericNode numericNode = (NumericNode)rootNode;
            if (numericNode.isInt()) {
                this.writeNumber(numericNode.intValue());
            } else if (numericNode.isLong()) {
                this.writeNumber(numericNode.longValue());
            } else if (numericNode.isShort()) {
                this.writeNumber(numericNode.shortValue());
            } else if (numericNode.isDouble()) {
                this.writeNumber(numericNode.doubleValue());
            } else if (numericNode.isFloat()) {
                this.writeNumber(numericNode.floatValue());
            } else if (numericNode.isBigDecimal()) {
                this.writeNumber(numericNode.decimalValue());
            } else if (numericNode.isBigInteger()) {
                this.writeNumber(numericNode.bigIntegerValue());
            }
        } else if (rootNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)rootNode;
            this.writeObject(arrayNode);
        } else if (rootNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)rootNode;
            this.writeObject(objectNode);
        } else if (rootNode instanceof NullNode || rootNode instanceof MissingNode) {
            this.writeNull();
        } else if (rootNode instanceof POJONode) {
            this.writeObject(((POJONode)rootNode).getPojo());
        }
    }

    @Override
    public void close() {
    }
}

