/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;

public final class LoggingUtils {
    private static ObjectMapper objectMapper;

    private LoggingUtils() {
    }

    public static void appendKey(String key, String value) {
        ThreadContext.put((String)key, (String)value);
    }

    public static void appendKeys(Map<String, String> customKeys) {
        ThreadContext.putAll(customKeys);
    }

    public static void removeKey(String customKey) {
        ThreadContext.remove((String)customKey);
    }

    public static void removeKeys(String ... keys) {
        ThreadContext.removeAll(Arrays.asList(keys));
    }

    public static void setCorrelationId(String value) {
        ThreadContext.put((String)"correlation_id", (String)value);
    }

    public static void defaultObjectMapper(ObjectMapper objectMapper) {
        LoggingUtils.objectMapper = objectMapper;
    }

    public static ObjectMapper objectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
        }
        return objectMapper;
    }
}

