/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.logging.internal;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayoutDefaults;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.InstantFormatter;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import software.amazon.lambda.powertools.logging.internal.LoggingConstants;

public class LambdaTimestampResolver
implements EventResolver {
    private final EventResolver internalResolver;

    public LambdaTimestampResolver(TemplateResolverConfig config) {
        PatternResolverContext patternResolverContext = PatternResolverContext.fromConfig(config);
        this.internalResolver = new PatternResolver(patternResolverContext);
    }

    public void resolve(LogEvent value, JsonWriter jsonWriter) {
        this.internalResolver.resolve((Object)value, jsonWriter);
    }

    static String getName() {
        return "lambda-timestamp";
    }

    private static final class PatternResolver
    implements EventResolver {
        private final PatternResolverContext patternResolverContext;

        private PatternResolver(PatternResolverContext patternResolverContext) {
            this.patternResolverContext = patternResolverContext;
        }

        public synchronized void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
            boolean instantMatching = this.patternResolverContext.formatter.isInstantMatching((Instant)this.patternResolverContext.lastFormattedInstant, logEvent.getInstant());
            if (!instantMatching) {
                this.patternResolverContext.lastFormattedInstantBuffer.setLength(0);
                this.patternResolverContext.lastFormattedInstant.initFrom(logEvent.getInstant());
                this.patternResolverContext.formatter.format((Instant)this.patternResolverContext.lastFormattedInstant, this.patternResolverContext.lastFormattedInstantBuffer);
                StringBuilder jsonWriterStringBuilder = jsonWriter.getStringBuilder();
                int startIndex = jsonWriterStringBuilder.length();
                jsonWriter.writeString((CharSequence)this.patternResolverContext.lastFormattedInstantBuffer);
                this.patternResolverContext.lastFormattedInstantBuffer.setLength(0);
                this.patternResolverContext.lastFormattedInstantBuffer.append(jsonWriterStringBuilder, startIndex, jsonWriterStringBuilder.length());
            } else {
                jsonWriter.writeRawString((CharSequence)this.patternResolverContext.lastFormattedInstantBuffer);
            }
        }
    }

    private static final class PatternResolverContext {
        public static final String PATTERN = "pattern";
        private final InstantFormatter formatter;
        private final StringBuilder lastFormattedInstantBuffer = new StringBuilder();
        private final MutableInstant lastFormattedInstant = new MutableInstant();

        private PatternResolverContext(String pattern, TimeZone timeZone, Locale locale) {
            this.formatter = InstantFormatter.newBuilder().setPattern(pattern).setTimeZone(timeZone).setLocale(locale).build();
            this.lastFormattedInstant.initFromEpochSecond(-1L, 0);
        }

        private static PatternResolverContext fromConfig(TemplateResolverConfig config) {
            String pattern = PatternResolverContext.readPattern(config);
            TimeZone timeZone = PatternResolverContext.readTimeZone(config);
            Locale locale = config.getLocale(new String[]{PATTERN, "locale"});
            return new PatternResolverContext(pattern, timeZone, locale);
        }

        private static String readPattern(TemplateResolverConfig config) {
            String format = config.getString(new String[]{PATTERN, "format"});
            return format != null ? format : PatternResolverContext.getLambdaTimestampFormatOrDefault();
        }

        private static String getLambdaTimestampFormatOrDefault() {
            return "JSON".equals(LoggingConstants.LAMBDA_LOG_FORMAT) ? "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'" : JsonTemplateLayoutDefaults.getTimestampFormatPattern();
        }

        private static TimeZone readTimeZone(TemplateResolverConfig config) {
            String timeZoneId = config.getString(new String[]{PATTERN, "timeZone"});
            if (timeZoneId == null) {
                return JsonTemplateLayoutDefaults.getTimeZone();
            }
            boolean found = false;
            String[] stringArray = TimeZone.getAvailableIDs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String availableTimeZone = stringArray[n2];
                if (availableTimeZone.equalsIgnoreCase(timeZoneId)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                throw new IllegalArgumentException("invalid timestamp time zone: " + config);
            }
            return TimeZone.getTimeZone(timeZoneId);
        }
    }
}

