/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.powertools.largemessages.internal;

import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import java.util.HashMap;
import java.util.Map;
import software.amazon.lambda.powertools.largemessages.internal.LargeMessageProcessor;

class LargeSNSMessageProcessor
extends LargeMessageProcessor<SNSEvent.SNSRecord> {
    LargeSNSMessageProcessor() {
    }

    @Override
    protected String getMessageId(SNSEvent.SNSRecord message) {
        return message.getSNS().getMessageId();
    }

    @Override
    protected String getMessageContent(SNSEvent.SNSRecord message) {
        return message.getSNS().getMessage();
    }

    @Override
    protected void updateMessageContent(SNSEvent.SNSRecord message, String messageContent) {
        message.getSNS().setMessage(messageContent);
    }

    @Override
    protected boolean isLargeMessage(SNSEvent.SNSRecord message) {
        Map msgAttributes = message.getSNS().getMessageAttributes();
        return msgAttributes != null && msgAttributes.containsKey("ExtendedPayloadSize");
    }

    @Override
    protected void removeLargeMessageAttributes(SNSEvent.SNSRecord message) {
        HashMap newAttributes = new HashMap(message.getSNS().getMessageAttributes());
        newAttributes.remove("ExtendedPayloadSize");
        message.getSNS().setMessageAttributes(newAttributes);
    }
}

