/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jsii;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import software.amazon.jsii.JsiiCallbackHandler;
import software.amazon.jsii.JsiiClient;
import software.amazon.jsii.JsiiException;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.MessageInspector;
import software.amazon.jsii.NativeType;
import software.amazon.jsii.Util;
import software.amazon.jsii.api.Callback;

public final class JsiiRuntime {
    private static final String VERSION_BUILD_PART_REGEX = "\\+[a-z0-9]+$";
    private static boolean traceEnabled = false;
    static final ThreadLocal<MessageInspector> messageInspector = new ThreadLocal();
    private JsiiClient client;
    private Process childProcess;
    private BufferedReader stderr;
    private BufferedReader stdout;
    private BufferedWriter stdin;
    private JsiiCallbackHandler callbackHandler;

    JsonNode requestResponse(JsonNode request) {
        try {
            JsiiRuntime.notifyInspector(request, MessageInspector.MessageType.Request);
            String str = request.toString();
            this.stdin.write(str + "\n");
            this.stdin.flush();
            JsonNode resp = this.readNextResponse();
            if (resp.has("error")) {
                return this.processErrorResponse(resp);
            }
            if (resp.has("callback")) {
                return this.processCallbackResponse(resp);
            }
            return resp.get("ok");
        }
        catch (IOException e) {
            throw new JsiiException("Unable to send request to jsii-runtime: " + e.toString(), e);
        }
    }

    private JsonNode processErrorResponse(JsonNode resp) {
        String errorMessage = resp.get("error").asText();
        if (resp.has("stack")) {
            errorMessage = errorMessage + "\n" + resp.get("stack").asText();
        }
        throw new JsiiException(errorMessage);
    }

    private JsonNode processCallbackResponse(JsonNode resp) {
        if (this.callbackHandler == null) {
            throw new JsiiException("Cannot process callback since callbackHandler was not set");
        }
        Callback callback = JsiiObjectMapper.treeToValue(resp.get("callback"), NativeType.forClass(Callback.class));
        JsonNode result = null;
        String error = null;
        try {
            result = this.callbackHandler.handleCallback(callback);
        }
        catch (Exception e) {
            error = e.getCause() instanceof InvocationTargetException ? e.getCause().getCause().getMessage() : e.getMessage();
        }
        ObjectNode completeResponse = JsonNodeFactory.instance.objectNode();
        completeResponse.put("cbid", callback.getCbid());
        if (error != null) {
            completeResponse.put("err", error);
        }
        if (result != null) {
            completeResponse.set("result", result);
        }
        ObjectNode req = JsonNodeFactory.instance.objectNode();
        req.set("complete", (JsonNode)completeResponse);
        return this.requestResponse((JsonNode)req);
    }

    public void setCallbackHandler(JsiiCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    protected void finalize() throws Throwable {
        try {
            this.terminate();
        }
        finally {
            super.finalize();
        }
    }

    public void terminate() throws InterruptedException, IOException {
        if (this.stderr != null) {
            this.stderr.close();
            this.stderr = null;
        }
        if (this.stdout != null) {
            this.stdout.close();
            this.stdout = null;
        }
        if (this.stdin != null) {
            this.stdin.close();
            this.stdin = null;
        }
        if (this.childProcess != null) {
            this.childProcess.waitFor();
            this.childProcess = null;
        }
    }

    private void startRuntimeIfNeeded() {
        String jsiiRuntimeExecutable;
        if (this.childProcess != null) {
            return;
        }
        String jsiiDebug = System.getenv("JSII_DEBUG");
        if (!(jsiiDebug == null || jsiiDebug.isEmpty() || jsiiDebug.equalsIgnoreCase("false") || jsiiDebug.equalsIgnoreCase("0"))) {
            traceEnabled = true;
        }
        if ((jsiiRuntimeExecutable = System.getenv("JSII_RUNTIME")) == null) {
            jsiiRuntimeExecutable = this.prepareBundledRuntime();
        }
        if (traceEnabled) {
            System.err.println("jsii-runtime: " + jsiiRuntimeExecutable);
        }
        ProcessBuilder pb = new ProcessBuilder("node", jsiiRuntimeExecutable);
        if (traceEnabled) {
            pb.environment().put("JSII_DEBUG", "1");
        }
        pb.environment().put("JSII_AGENT", "Java/" + System.getProperty("java.version"));
        try {
            this.childProcess = pb.start();
        }
        catch (IOException e) {
            throw new JsiiException("Cannot find the 'jsii-runtime' executable (JSII_RUNTIME or PATH)");
        }
        OutputStreamWriter stdinStream = new OutputStreamWriter(this.childProcess.getOutputStream(), StandardCharsets.UTF_8);
        InputStreamReader stdoutStream = new InputStreamReader(this.childProcess.getInputStream(), StandardCharsets.UTF_8);
        InputStreamReader stderrStream = new InputStreamReader(this.childProcess.getErrorStream(), StandardCharsets.UTF_8);
        this.stderr = new BufferedReader(stderrStream);
        this.stdout = new BufferedReader(stdoutStream);
        this.stdin = new BufferedWriter(stdinStream);
        this.handshake();
        this.client = new JsiiClient(this);
        if (traceEnabled) {
            this.startPipeErrorStreamThread();
        }
    }

    private void handshake() {
        JsonNode helloResponse = this.readNextResponse();
        if (!helloResponse.has("hello")) {
            throw new JsiiException("Expecting 'hello' message from jsii-runtime");
        }
        String runtimeVersion = helloResponse.get("hello").asText();
        JsiiRuntime.assertVersionCompatible("@jsii/runtime@1.13.0", runtimeVersion);
    }

    JsonNode readNextResponse() {
        try {
            String responseLine = this.stdout.readLine();
            if (responseLine == null) {
                String error = this.stderr.lines().collect(Collectors.joining("\n\t"));
                throw new JsiiException("Child process exited unexpectedly: " + error);
            }
            JsonNode response = JsiiObjectMapper.INSTANCE.readTree(responseLine);
            JsiiRuntime.notifyInspector(response, MessageInspector.MessageType.Response);
            return response;
        }
        catch (IOException e) {
            throw new JsiiException("Unable to read reply from jsii-runtime: " + e.toString(), e);
        }
    }

    private void startPipeErrorStreamThread() {
        Thread daemon = new Thread(() -> {
            while (true) {
                try {
                    String line;
                    do {
                        line = this.stderr.readLine();
                        System.err.println(line);
                    } while (line != null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        daemon.setDaemon(true);
        daemon.start();
    }

    public JsiiClient getClient() {
        this.startRuntimeIfNeeded();
        if (this.client == null) {
            throw new JsiiException("Client not created");
        }
        return this.client;
    }

    public static void enableTrace() {
        traceEnabled = true;
    }

    static void assertVersionCompatible(String expectedVersion, String actualVersion) {
        String shortActualVersion = actualVersion.replaceAll(VERSION_BUILD_PART_REGEX, "");
        String shortExpectedVersion = expectedVersion.replaceAll(VERSION_BUILD_PART_REGEX, "");
        if (shortExpectedVersion.compareTo(shortActualVersion) != 0) {
            throw new JsiiException("Incompatible jsii-runtime version. Expecting " + shortExpectedVersion + ", actual was " + shortActualVersion);
        }
    }

    private String prepareBundledRuntime() {
        try {
            Path directory = Files.createTempDirectory("jsii-java-runtime", new FileAttribute[0]);
            directory.toFile().deleteOnExit();
            Path entrypoint = Util.extractResource(this.getClass(), "jsii-runtime.js", directory);
            entrypoint.toFile().deleteOnExit();
            Util.extractResource(this.getClass(), "jsii-runtime.js.map", directory).toFile().deleteOnExit();
            Util.extractResource(this.getClass(), "mappings.wasm", directory).toFile().deleteOnExit();
            return entrypoint.toString();
        }
        catch (IOException e) {
            throw new JsiiException("Unable to extract bundle of jsii-runtime.js from jar", e);
        }
    }

    private static void notifyInspector(JsonNode message, MessageInspector.MessageType type) {
        MessageInspector inspector = messageInspector.get();
        if (inspector == null) {
            return;
        }
        inspector.inspect(message, type);
    }
}

