/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.wrapper.ConnectionWrapper;

public class SavepointWrapper
implements Savepoint {
    protected final Savepoint savepoint;
    protected final ConnectionWrapper connectionWrapper;
    protected final ConnectionPluginManager pluginManager;

    public SavepointWrapper(@NonNull Savepoint savepoint, @NonNull ConnectionWrapper connectionWrapper, @NonNull ConnectionPluginManager pluginManager) {
        this.savepoint = savepoint;
        this.connectionWrapper = connectionWrapper;
        this.pluginManager = pluginManager;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.SAVEPOINT_GETSAVEPOINTID)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.connectionWrapper, this.pluginManager, this.savepoint, JdbcMethod.SAVEPOINT_GETSAVEPOINTID, () -> this.savepoint.getSavepointId(), new Object[0]);
        }
        return this.savepoint.getSavepointId();
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.SAVEPOINT_GETSAVEPOINTNAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.connectionWrapper, this.pluginManager, this.savepoint, JdbcMethod.SAVEPOINT_GETSAVEPOINTNAME, () -> this.savepoint.getSavepointName(), new Object[0]);
        }
        return this.savepoint.getSavepointName();
    }

    public String toString() {
        return super.toString() + " - " + this.savepoint;
    }
}

