/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.storage;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.util.storage.ShouldDisposeFunc;

public class CacheItem<V> {
    protected final @NonNull V item;
    protected long expirationTimeNanos;
    protected final @Nullable ShouldDisposeFunc<V> shouldDisposeFunc;

    protected CacheItem(@NonNull V item, long expirationTimeNanos) {
        this.item = item;
        this.expirationTimeNanos = expirationTimeNanos;
        this.shouldDisposeFunc = null;
    }

    protected CacheItem(@NonNull V item, long expirationTimeNanos, @Nullable ShouldDisposeFunc<V> shouldDisposeFunc) {
        this.item = item;
        this.expirationTimeNanos = expirationTimeNanos;
        this.shouldDisposeFunc = shouldDisposeFunc;
    }

    protected boolean isExpired() {
        return System.nanoTime() > this.expirationTimeNanos;
    }

    protected void extendExpiration(long timeToLiveNanos) {
        this.expirationTimeNanos = System.nanoTime() + timeToLiveNanos;
    }

    protected boolean shouldCleanup() {
        boolean isExpired;
        boolean bl = isExpired = this.expirationTimeNanos != 0L && System.nanoTime() > this.expirationTimeNanos;
        if (this.shouldDisposeFunc != null) {
            return isExpired && this.shouldDisposeFunc.shouldDispose(this.item);
        }
        return isExpired;
    }

    public int hashCode() {
        return Objects.hashCode(this.item);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheItem other = (CacheItem)obj;
        return Objects.equals(this.item, other.item);
    }

    public String toString() {
        return "CacheItem [item=" + this.item + ", expirationTimeNanos=" + this.expirationTimeNanos + "]";
    }
}

