/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.events;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.events.Event;
import software.amazon.jdbc.util.events.EventPublisher;
import software.amazon.jdbc.util.events.EventSubscriber;

public class BatchingEventPublisher
implements EventPublisher {
    protected static final long DEFAULT_MESSAGE_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(30L);
    protected final Map<Class<? extends Event>, Set<EventSubscriber>> subscribersMap = new ConcurrentHashMap<Class<? extends Event>, Set<EventSubscriber>>();
    protected final Set<Event> eventMessages = ConcurrentHashMap.newKeySet();
    protected static final ScheduledExecutorService publishingExecutor = ExecutorFactory.newSingleThreadScheduledThreadExecutor("bep");

    public BatchingEventPublisher() {
        this(DEFAULT_MESSAGE_INTERVAL_NANOS);
    }

    public BatchingEventPublisher(long messageIntervalNanos) {
        this.initPublishingThread(messageIntervalNanos);
    }

    protected void initPublishingThread(long messageIntervalNanos) {
        publishingExecutor.scheduleAtFixedRate(this::sendMessages, messageIntervalNanos, messageIntervalNanos, TimeUnit.NANOSECONDS);
    }

    protected void sendMessages() {
        Iterator<Event> iterator = this.eventMessages.iterator();
        while (iterator.hasNext()) {
            Event event = iterator.next();
            iterator.remove();
            Set<EventSubscriber> subscribers = this.subscribersMap.get(event.getClass());
            if (subscribers == null) continue;
            for (EventSubscriber subscriber : subscribers) {
                subscriber.processEvent(event);
            }
        }
    }

    @Override
    public void subscribe(EventSubscriber subscriber, Set<Class<? extends Event>> eventClasses) {
        for (Class<? extends Event> eventClass : eventClasses) {
            this.subscribersMap.computeIfAbsent(eventClass, k -> Collections.newSetFromMap(new WeakHashMap())).add(subscriber);
        }
    }

    @Override
    public void unsubscribe(EventSubscriber subscriber, Set<Class<? extends Event>> eventClasses) {
        for (Class<? extends Event> eventClass : eventClasses) {
            this.subscribersMap.computeIfPresent(eventClass, (k, v) -> {
                v.remove(subscriber);
                return v.isEmpty() ? null : v;
            });
        }
    }

    @Override
    public void publish(Event event) {
        this.eventMessages.add(event);
    }
}

