/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.efm.ExecutorServiceInitializer;
import software.amazon.jdbc.plugin.efm.HostMonitor;
import software.amazon.jdbc.plugin.efm.HostMonitorConnectionContext;
import software.amazon.jdbc.plugin.efm.HostMonitorImpl;
import software.amazon.jdbc.plugin.efm.HostMonitorInitializer;
import software.amazon.jdbc.plugin.efm.HostMonitorService;
import software.amazon.jdbc.plugin.efm.HostMonitorThreadContainer;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class HostMonitorServiceImpl
implements HostMonitorService {
    private static final Logger LOGGER = Logger.getLogger(HostMonitorServiceImpl.class.getName());
    public static final AwsWrapperProperty MONITOR_DISPOSAL_TIME_MS = new AwsWrapperProperty("monitorDisposalTime", "600000", "Interval in milliseconds for a monitor to be considered inactive and to be disposed.");
    private final PluginService pluginService;
    private HostMonitorThreadContainer threadContainer;
    final HostMonitorInitializer monitorInitializer;
    private Set<String> cachedMonitorNodeKeys = null;
    private WeakReference<HostMonitor> cachedMonitor = null;
    final TelemetryFactory telemetryFactory;
    final TelemetryCounter abortedConnectionsCounter;

    public HostMonitorServiceImpl(@NonNull PluginService pluginService) {
        this(pluginService, (hostSpec, properties, monitorService) -> new HostMonitorImpl(pluginService, hostSpec, properties, MONITOR_DISPOSAL_TIME_MS.getLong(properties), monitorService), () -> ExecutorFactory.newCachedThreadPool("monitor"));
    }

    HostMonitorServiceImpl(PluginService pluginService, HostMonitorInitializer monitorInitializer, ExecutorServiceInitializer executorServiceInitializer) {
        this.pluginService = pluginService;
        this.telemetryFactory = pluginService.getTelemetryFactory();
        this.abortedConnectionsCounter = this.telemetryFactory.createCounter("efm.connections.aborted");
        this.monitorInitializer = monitorInitializer;
        this.threadContainer = HostMonitorThreadContainer.getInstance(executorServiceInitializer);
    }

    @Override
    public HostMonitorConnectionContext startMonitoring(Connection connectionToAbort, Set<String> nodeKeys, HostSpec hostSpec, Properties properties, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        HostMonitor monitor;
        if (nodeKeys.isEmpty()) {
            throw new IllegalArgumentException(Messages.get("HostMonitorServiceImpl.emptyAliasSet", new Object[]{hostSpec}));
        }
        HostMonitor hostMonitor = monitor = this.cachedMonitor == null ? null : (HostMonitor)this.cachedMonitor.get();
        if (monitor == null || monitor.isStopped() || this.cachedMonitorNodeKeys == null || !this.cachedMonitorNodeKeys.equals(nodeKeys)) {
            monitor = this.getMonitor(nodeKeys, hostSpec, properties);
            this.cachedMonitor = new WeakReference<HostMonitor>(monitor);
            this.cachedMonitorNodeKeys = Collections.unmodifiableSet(nodeKeys);
        }
        HostMonitorConnectionContext context = new HostMonitorConnectionContext(monitor, connectionToAbort, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, this.abortedConnectionsCounter);
        monitor.startMonitoring(context);
        return context;
    }

    @Override
    public void stopMonitoring(@NonNull HostMonitorConnectionContext context) {
        HostMonitor monitor = context.getMonitor();
        monitor.stopMonitoring(context);
    }

    @Override
    public void stopMonitoringForAllConnections(@NonNull Set<String> nodeKeys) {
        for (String nodeKey : nodeKeys) {
            HostMonitor monitor = this.threadContainer.getMonitor(nodeKey);
            if (monitor == null) continue;
            monitor.clearContexts();
            return;
        }
    }

    @Override
    public void releaseResources() {
        this.threadContainer = null;
    }

    protected HostMonitor getMonitor(Set<String> nodeKeys, HostSpec hostSpec, Properties properties) {
        return this.threadContainer.getOrCreateMonitor(nodeKeys, () -> this.monitorInitializer.createMonitor(hostSpec, properties, this.threadContainer));
    }

    HostMonitorThreadContainer getThreadContainer() {
        return this.threadContainer;
    }
}

