/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen.routing;

import java.sql.SQLTimeoutException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenConnectionPlugin;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenPhase;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenStatus;
import software.amazon.jdbc.plugin.bluegreen.routing.BaseExecuteRouting;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.util.storage.StorageService;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class SuspendExecuteRouting
extends BaseExecuteRouting {
    private static final Logger LOGGER = Logger.getLogger(SuspendExecuteRouting.class.getName());
    protected static final String TELEMETRY_SWITCHOVER = "Blue/Green switchover";
    private static final long SLEEP_TIME_MS = 100L;
    protected String bgdId;

    public SuspendExecuteRouting(@Nullable String hostAndPort, @Nullable BlueGreenRole role, String bgdId) {
        super(hostAndPort, role);
        this.bgdId = bgdId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> @NonNull Optional<T> apply(ConnectionPlugin plugin, Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs, StorageService storageService, PluginService pluginService, Properties props) throws E {
        LOGGER.finest(Messages.get("bgd.inProgressSuspendMethod", new Object[]{methodName}));
        TelemetryFactory telemetryFactory = pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_SWITCHOVER, TelemetryTraceLevel.NESTED);
        BlueGreenStatus bgStatus = storageService.get(BlueGreenStatus.class, this.bgdId);
        long timeoutNano = TimeUnit.MILLISECONDS.toNanos(BlueGreenConnectionPlugin.BG_CONNECT_TIMEOUT.getLong(props));
        long holdStartTime = this.getNanoTime();
        long endTime = this.getNanoTime() + timeoutNano;
        try {
            while (this.getNanoTime() <= endTime && bgStatus != null && bgStatus.getCurrentPhase() == BlueGreenPhase.IN_PROGRESS) {
                try {
                    this.delay(100L, bgStatus, storageService, this.bgdId);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                bgStatus = storageService.get(BlueGreenStatus.class, this.bgdId);
            }
            if (bgStatus != null && bgStatus.getCurrentPhase() == BlueGreenPhase.IN_PROGRESS) {
                throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, new SQLTimeoutException(Messages.get("bgd.stillInProgressTryMethodLater", new Object[]{BlueGreenConnectionPlugin.BG_CONNECT_TIMEOUT.getLong(props), methodName})));
            }
            LOGGER.finest(() -> Messages.get("bgd.switchoverCompletedContinueWithMethod", new Object[]{methodName, TimeUnit.NANOSECONDS.toMillis(this.getNanoTime() - holdStartTime)}));
        }
        finally {
            if (telemetryContext != null) {
                telemetryContext.closeContext();
            }
        }
        return Optional.empty();
    }
}

