/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.HostListProvider;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.HostSpecBuilder;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.dialect.BlueGreenDialect;
import software.amazon.jdbc.hostavailability.SimpleHostAvailabilityStrategy;
import software.amazon.jdbc.hostlistprovider.RdsHostListProvider;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenInterimStatus;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenIntervalRate;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenPhase;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.OnBlueGreenStatusChange;
import software.amazon.jdbc.plugin.iam.IamAuthConnectionPlugin;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.ExecutorFactory;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.RdsUtils;

public class BlueGreenStatusMonitor {
    private static final Logger LOGGER = Logger.getLogger(BlueGreenStatusMonitor.class.getName());
    protected static final long DEFAULT_CHECK_INTERVAL_MS = TimeUnit.MINUTES.toMillis(5L);
    protected static final String BG_CLUSTER_ID = "941d00a8-8238-4f7d-bf59-771bff783a8e";
    protected static final String latestKnownVersion = "1.0";
    protected static final Set<String> knownVersions = new HashSet<String>(Collections.singletonList("1.0"));
    protected final BlueGreenDialect blueGreenDialect;
    protected final FullServicesContainer servicesContainer;
    protected final PluginService pluginService;
    protected final String bgdId;
    protected final Properties props;
    protected final BlueGreenRole role;
    protected final OnBlueGreenStatusChange onBlueGreenStatusChangeFunc;
    protected final Map<BlueGreenIntervalRate, Long> statusCheckIntervalMap;
    protected final HostSpec initialHostSpec;
    protected final ExecutorService executorService = Executors.newFixedThreadPool(1);
    protected final ExecutorService openConnectionExecutorService = ExecutorFactory.newSingleThreadExecutor("open-connection");
    protected final RdsUtils rdsUtils = new RdsUtils();
    protected final ConnectionUrlParser connectionUrlParser = new ConnectionUrlParser();
    protected final HostSpecBuilder hostSpecBuilder = new HostSpecBuilder(new SimpleHostAvailabilityStrategy());
    protected final AtomicBoolean collectIpAddresses = new AtomicBoolean(true);
    protected final AtomicBoolean collectTopology = new AtomicBoolean(true);
    protected final AtomicReference<BlueGreenIntervalRate> intervalRate = new AtomicReference<BlueGreenIntervalRate>(BlueGreenIntervalRate.BASELINE);
    protected final AtomicBoolean stop = new AtomicBoolean(false);
    protected final AtomicBoolean useIpAddress = new AtomicBoolean(false);
    protected final Object sleepWaitObj = new Object();
    protected HostListProvider hostListProvider = null;
    protected List<HostSpec> startTopology = new ArrayList<HostSpec>();
    protected final AtomicReference<List<HostSpec>> currentTopology = new AtomicReference(new ArrayList());
    protected Map<String, Optional<String>> startIpAddressesByHostMap = new ConcurrentHashMap<String, Optional<String>>();
    protected Map<String, Optional<String>> currentIpAddressesByHostMap = new ConcurrentHashMap<String, Optional<String>>();
    protected boolean allStartTopologyIpChanged = false;
    protected boolean allStartTopologyEndpointsRemoved = false;
    protected boolean allTopologyChanged = false;
    protected BlueGreenPhase currentPhase = BlueGreenPhase.NOT_CREATED;
    protected Set<String> hostNames = ConcurrentHashMap.newKeySet();
    protected String version = "1.0";
    protected int port = -1;
    protected final AtomicReference<Connection> connection = new AtomicReference<Object>(null);
    protected final AtomicReference<HostSpec> connectionHostSpec = new AtomicReference<Object>(null);
    protected final AtomicReference<String> connectedIpAddress = new AtomicReference<Object>(null);
    protected final AtomicBoolean connectionHostSpecCorrect = new AtomicBoolean(false);
    protected final AtomicBoolean panicMode = new AtomicBoolean(true);
    protected Future<Void> openConnectionFuture = null;

    public BlueGreenStatusMonitor(@NonNull BlueGreenRole role, @NonNull String bgdId, @NonNull HostSpec initialHostSpec, @NonNull FullServicesContainer servicesContainer, @NonNull Properties props, @NonNull Map<BlueGreenIntervalRate, Long> statusCheckIntervalMap, @Nullable OnBlueGreenStatusChange onBlueGreenStatusChangeFunc) {
        this.role = role;
        this.bgdId = bgdId;
        this.initialHostSpec = initialHostSpec;
        this.servicesContainer = servicesContainer;
        this.pluginService = servicesContainer.getPluginService();
        this.props = props;
        this.statusCheckIntervalMap = statusCheckIntervalMap;
        this.onBlueGreenStatusChangeFunc = onBlueGreenStatusChangeFunc;
        this.blueGreenDialect = (BlueGreenDialect)((Object)this.pluginService.getDialect());
        this.executorService.submit(this::runMonitoringLoop);
        this.executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void runMonitoringLoop() {
        block7: while (true) {
            while (!this.stop.get()) {
                try {
                    BlueGreenPhase oldPhase = this.currentPhase;
                    this.openConnection();
                    this.collectStatus();
                    this.collectTopology();
                    this.collectHostIpAddresses();
                    this.updateIpAddressFlags();
                    if (this.currentPhase != null && (oldPhase == null || oldPhase != this.currentPhase)) {
                        LOGGER.finest(() -> Messages.get("bgd.statusChanged", new Object[]{this.role, this.currentPhase}));
                    }
                    if (this.onBlueGreenStatusChangeFunc != null) {
                        this.onBlueGreenStatusChangeFunc.onBlueGreenStatusChanged(this.role, new BlueGreenInterimStatus(this.currentPhase, this.version, this.port, this.startTopology, this.currentTopology.get(), this.startIpAddressesByHostMap, this.currentIpAddressesByHostMap, this.hostNames, this.allStartTopologyIpChanged, this.allStartTopologyEndpointsRemoved, this.allTopologyChanged));
                    }
                    long delayMs = this.statusCheckIntervalMap.getOrDefault((Object)(this.panicMode.get() ? BlueGreenIntervalRate.HIGH : this.intervalRate.get()), DEFAULT_CHECK_INTERVAL_MS);
                    this.delay(delayMs);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    LOGGER.finest(() -> Messages.get("bgd.interrupted", new Object[]{this.role}));
                    this.closeConnection();
                    LOGGER.finest(() -> Messages.get("bgd.threadCompleted", new Object[]{this.role}));
                    return;
                }
                catch (Exception ex) {
                    try {
                        if (!LOGGER.isLoggable(Level.WARNING)) continue block7;
                        LOGGER.log(Level.WARNING, Messages.get("bgd.monitoringUnhandledException", new Object[]{this.role}), ex);
                        continue block7;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.closeConnection();
            LOGGER.finest(() -> Messages.get("bgd.threadCompleted", new Object[]{this.role}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delay(long delayMs) throws InterruptedException {
        long start = System.nanoTime();
        long end = start + TimeUnit.MILLISECONDS.toNanos(delayMs);
        BlueGreenIntervalRate currentBlueGreenIntervalRate = this.intervalRate.get();
        boolean currentPanic = this.panicMode.get();
        long minDelay = Math.min(delayMs, 50L);
        do {
            Object object = this.sleepWaitObj;
            synchronized (object) {
                this.sleepWaitObj.wait(minDelay);
            }
        } while (this.intervalRate.get() == currentBlueGreenIntervalRate && System.nanoTime() < end && !this.stop.get() && currentPanic == this.panicMode.get());
    }

    public void setIntervalRate(@NonNull BlueGreenIntervalRate blueGreenIntervalRate) {
        this.intervalRate.set(blueGreenIntervalRate);
        this.notifyChanges();
    }

    public void setCollectIpAddresses(boolean collectIpAddresses) {
        this.collectIpAddresses.set(collectIpAddresses);
    }

    public void setCollectTopology(boolean collectTopology) {
        this.collectTopology.set(collectTopology);
    }

    public void setUseIpAddress(boolean useIpAddress) {
        this.useIpAddress.set(useIpAddress);
    }

    public void setStop(boolean stop) {
        this.stop.set(stop);
        this.notifyChanges();
    }

    public void resetCollectedData() {
        this.startIpAddressesByHostMap.clear();
        this.startTopology = new ArrayList<HostSpec>();
        this.hostNames.clear();
    }

    protected void collectHostIpAddresses() {
        this.currentIpAddressesByHostMap.clear();
        if (this.hostNames != null) {
            for (String host : this.hostNames) {
                this.currentIpAddressesByHostMap.putIfAbsent(host, this.getIpAddress(host));
            }
        }
        if (this.collectIpAddresses.get()) {
            this.startIpAddressesByHostMap.clear();
            this.startIpAddressesByHostMap.putAll(this.currentIpAddressesByHostMap);
        }
    }

    protected void updateIpAddressFlags() {
        if (this.collectTopology.get()) {
            this.allStartTopologyIpChanged = false;
            this.allStartTopologyEndpointsRemoved = false;
            this.allTopologyChanged = false;
            return;
        }
        if (!this.collectIpAddresses.get()) {
            this.allStartTopologyIpChanged = !this.startTopology.isEmpty() && this.startTopology.stream().allMatch(x -> {
                String host = x.getHost();
                Optional<String> startIp = this.startIpAddressesByHostMap.get(host);
                Optional<String> currentIp = this.currentIpAddressesByHostMap.get(host);
                return startIp != null && startIp.isPresent() && currentIp != null && currentIp.isPresent() && !startIp.get().equals(currentIp.get());
            });
        }
        boolean bl = this.allStartTopologyEndpointsRemoved = !this.startTopology.isEmpty() && this.startTopology.stream().allMatch(x -> {
            String host = x.getHost();
            Optional<String> startIp = this.startIpAddressesByHostMap.get(host);
            Optional<String> currentIp = this.currentIpAddressesByHostMap.get(host);
            return startIp != null && startIp.isPresent() && currentIp != null && !currentIp.isPresent();
        });
        if (!this.collectTopology.get()) {
            HashSet startTopologyNodes = this.startTopology == null ? new HashSet() : this.startTopology.stream().map(HostSpec::getHost).collect(Collectors.toSet());
            List<HostSpec> currentTopologyCopy = this.currentTopology.get();
            this.allTopologyChanged = currentTopologyCopy != null && !currentTopologyCopy.isEmpty() && !startTopologyNodes.isEmpty() && currentTopologyCopy.stream().noneMatch(x -> startTopologyNodes.contains(x.getHost()));
        }
    }

    protected Optional<String> getIpAddress(String host) {
        try {
            return Optional.of(InetAddress.getByName(host).getHostAddress());
        }
        catch (UnknownHostException ex) {
            return Optional.empty();
        }
    }

    protected void collectTopology() throws SQLException {
        List<HostSpec> currentTopologyCopy;
        if (this.hostListProvider == null) {
            return;
        }
        Connection conn = this.connection.get();
        if (conn == null || conn.isClosed()) {
            return;
        }
        this.currentTopology.set(this.hostListProvider.forceRefresh(conn));
        if (this.collectTopology.get()) {
            this.startTopology = this.currentTopology.get();
        }
        if ((currentTopologyCopy = this.currentTopology.get()) != null && this.collectTopology.get()) {
            this.hostNames.addAll(currentTopologyCopy.stream().map(HostSpec::getHost).collect(Collectors.toSet()));
        }
    }

    protected void closeConnection() {
        Connection conn = this.connection.get();
        this.connection.set(null);
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void collectStatus() {
        block25: {
            Connection conn = this.connection.get();
            try {
                if (conn == null || conn.isClosed()) {
                    return;
                }
                if (!this.blueGreenDialect.isBlueGreenStatusAvailable(conn)) {
                    if (!conn.isClosed()) {
                        this.currentPhase = BlueGreenPhase.NOT_CREATED;
                        LOGGER.finest(() -> Messages.get("bgd.statusNotAvailable", new Object[]{this.role, BlueGreenPhase.NOT_CREATED}));
                    } else {
                        this.connection.set(null);
                        this.currentPhase = null;
                        this.panicMode.set(true);
                    }
                    return;
                }
                Statement statement = conn.createStatement();
                ResultSet resultSet = statement.executeQuery(this.blueGreenDialect.getBlueGreenStatusQuery());
                ArrayList<StatusInfo> statusEntries = new ArrayList<StatusInfo>();
                while (resultSet.next()) {
                    String version = resultSet.getString("version");
                    if (!knownVersions.contains(version)) {
                        String versionCopy = version;
                        version = latestKnownVersion;
                        LOGGER.warning(() -> Messages.get("bgd.usesVersion", new Object[]{this.role, versionCopy, latestKnownVersion}));
                    }
                    String endpoint = resultSet.getString("endpoint");
                    int port = resultSet.getInt("port");
                    BlueGreenRole role = BlueGreenRole.parseRole(resultSet.getString("role"), version);
                    BlueGreenPhase phase = BlueGreenPhase.parsePhase(resultSet.getString("status"), version);
                    if (this.role != role) continue;
                    statusEntries.add(new StatusInfo(version, endpoint, port, phase, role));
                }
                StatusInfo statusInfo = statusEntries.stream().filter(x -> this.rdsUtils.isWriterClusterDns(x.endpoint) && this.rdsUtils.isNotOldInstance(x.endpoint)).findFirst().orElse(null);
                if (statusInfo != null) {
                    this.hostNames.add(statusInfo.endpoint.toLowerCase().replace(".cluster-", ".cluster-ro-"));
                }
                if (statusInfo == null) {
                    statusInfo = statusEntries.stream().filter(x -> this.rdsUtils.isRdsInstance(x.endpoint) && this.rdsUtils.isNotOldInstance(x.endpoint)).findFirst().orElse(null);
                }
                if (statusInfo == null) {
                    if (statusEntries.isEmpty()) {
                        if (this.role != BlueGreenRole.SOURCE) {
                            LOGGER.finest(() -> Messages.get("bgd.noEntriesInStatusTable", new Object[]{this.role}));
                        }
                        this.currentPhase = null;
                    }
                } else {
                    this.currentPhase = statusInfo.phase;
                    this.version = statusInfo.version;
                    this.port = statusInfo.port;
                }
                if (this.collectTopology.get()) {
                    this.hostNames.addAll(statusEntries.stream().filter(x -> x.endpoint != null && this.rdsUtils.isNotOldInstance(x.endpoint)).map(x -> x.endpoint.toLowerCase()).collect(Collectors.toSet()));
                }
                if (!this.connectionHostSpecCorrect.get() && statusInfo != null) {
                    String statusInfoHostIpAddress = this.getIpAddress(statusInfo.endpoint).orElse(null);
                    String connectedIpAddressCopy = this.connectedIpAddress.get();
                    if (connectedIpAddressCopy != null && !connectedIpAddressCopy.equals(statusInfoHostIpAddress)) {
                        this.connectionHostSpec.set(this.hostSpecBuilder.host(statusInfo.endpoint).port(statusInfo.port).build());
                        this.connectionHostSpecCorrect.set(true);
                        this.closeConnection();
                        this.panicMode.set(true);
                    } else {
                        this.connectionHostSpecCorrect.set(true);
                        this.panicMode.set(false);
                    }
                }
                if (this.connectionHostSpecCorrect.get() && this.hostListProvider == null) {
                    this.initHostListProvider();
                }
            }
            catch (SQLSyntaxErrorException sqlSyntaxErrorException) {
                this.currentPhase = BlueGreenPhase.NOT_CREATED;
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, Messages.get("bgd.exception", new Object[]{this.role, BlueGreenPhase.NOT_CREATED}), sqlSyntaxErrorException);
                }
            }
            catch (SQLException e) {
                if (!this.isConnectionClosed(conn)) {
                    if (e.getMessage() != null && e.getMessage().contains("An error occured while retrieving the blue/green fast switchover metadata")) {
                        this.currentPhase = BlueGreenPhase.NOT_CREATED;
                        return;
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, Messages.get("bgd.unhandledSqlException", new Object[]{this.role}), e);
                    }
                }
                this.closeConnection();
                this.panicMode.set(true);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block25;
                LOGGER.log(Level.FINEST, Messages.get("bgd.unhandledException", new Object[]{this.role}), e);
            }
        }
    }

    protected boolean isConnectionClosed(Connection conn) {
        try {
            return conn == null || conn.isClosed();
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    protected void openConnection() {
        Connection conn = this.connection.get();
        if (!this.isConnectionClosed(conn)) {
            return;
        }
        if (this.openConnectionFuture != null) {
            if (this.openConnectionFuture.isDone()) {
                if (!this.panicMode.get()) {
                    return;
                }
            } else {
                if (!this.openConnectionFuture.isCancelled()) {
                    return;
                }
                this.openConnectionFuture = null;
            }
        }
        this.connection.set(null);
        this.panicMode.set(true);
        this.openConnectionFuture = this.openConnectionExecutorService.submit(() -> {
            HostSpec connectionHostSpecCopy = this.connectionHostSpec.get();
            String connectedIpAddressCopy = this.connectedIpAddress.get();
            if (connectionHostSpecCopy == null) {
                this.connectionHostSpec.set(this.initialHostSpec);
                connectionHostSpecCopy = this.initialHostSpec;
                this.connectedIpAddress.set(null);
                connectedIpAddressCopy = null;
                this.connectionHostSpecCorrect.set(false);
            }
            try {
                if (this.useIpAddress.get() && connectedIpAddressCopy != null) {
                    HostSpec connectionWithIpHostSpec = this.hostSpecBuilder.copyFrom(connectionHostSpecCopy).host(connectedIpAddressCopy).build();
                    Properties connectWithIpProperties = PropertyUtils.copyProperties(this.props);
                    IamAuthConnectionPlugin.IAM_HOST.set(connectWithIpProperties, connectionHostSpecCopy.getHost());
                    LOGGER.finest(() -> Messages.get("bgd.openingConnectionWithIp", new Object[]{this.role, connectionWithIpHostSpec.getHost()}));
                    this.connection.set(this.pluginService.forceConnect(connectionWithIpHostSpec, connectWithIpProperties));
                    LOGGER.finest(() -> Messages.get("bgd.openedConnectionWithIp", new Object[]{this.role, connectionWithIpHostSpec.getHost()}));
                } else {
                    HostSpec finalConnectionHostSpecCopy = connectionHostSpecCopy;
                    LOGGER.finest(() -> Messages.get("bgd.openingConnection", new Object[]{this.role, finalConnectionHostSpecCopy.getHost()}));
                    connectedIpAddressCopy = this.getIpAddress(connectionHostSpecCopy.getHost()).orElse(null);
                    this.connection.set(this.pluginService.forceConnect(connectionHostSpecCopy, this.props));
                    this.connectedIpAddress.set(connectedIpAddressCopy);
                    LOGGER.finest(() -> Messages.get("bgd.openedConnection", new Object[]{this.role, finalConnectionHostSpecCopy.getHost()}));
                }
                this.panicMode.set(false);
                this.notifyChanges();
            }
            catch (SQLException ex) {
                this.connection.set(null);
                this.panicMode.set(true);
                this.notifyChanges();
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChanges() {
        Object object = this.sleepWaitObj;
        synchronized (object) {
            this.sleepWaitObj.notifyAll();
        }
    }

    protected void initHostListProvider() {
        if (this.hostListProvider != null || !this.connectionHostSpecCorrect.get()) {
            return;
        }
        Properties hostListProperties = PropertyUtils.copyProperties(this.props);
        RdsHostListProvider.CLUSTER_ID.set(hostListProperties, String.format("%s::%s::%s", new Object[]{this.bgdId, this.role, BG_CLUSTER_ID}));
        LOGGER.finest(() -> Messages.get("bgd.createHostListProvider", new Object[]{this.role, RdsHostListProvider.CLUSTER_ID.getString(hostListProperties)}));
        String protocol = this.connectionUrlParser.getProtocol(this.pluginService.getOriginalUrl());
        HostSpec connectionHostSpecCopy = this.connectionHostSpec.get();
        if (connectionHostSpecCopy != null) {
            String hostListProviderUrl = String.format("%s%s/", protocol, connectionHostSpecCopy.getHostAndPort());
            this.hostListProvider = this.pluginService.getDialect().getHostListProvider().getProvider(hostListProperties, hostListProviderUrl, this.servicesContainer);
        } else {
            LOGGER.warning(() -> Messages.get("bgd.hostSpecNull"));
        }
    }

    private static class StatusInfo {
        public String version;
        public String endpoint;
        public int port;
        public BlueGreenPhase phase;
        public BlueGreenRole role;

        StatusInfo(String version, String endpoint, int port, BlueGreenPhase phase, BlueGreenRole role) {
            this.version = version;
            this.endpoint = endpoint;
            this.port = port;
            this.phase = phase;
            this.role = role;
        }
    }
}

