/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenPhase;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.routing.ConnectRouting;
import software.amazon.jdbc.plugin.bluegreen.routing.ExecuteRouting;
import software.amazon.jdbc.util.Pair;
import software.amazon.jdbc.util.StringUtils;

public class BlueGreenStatus {
    private static final Logger LOGGER = Logger.getLogger(BlueGreenStatus.class.getName());
    private final String bgdId;
    private final BlueGreenPhase currentPhase;
    private final List<ConnectRouting> unmodifiableConnectRouting;
    private final List<ExecuteRouting> unmodifiableExecuteRouting;
    private final Map<String, BlueGreenRole> roleByHost = new ConcurrentHashMap<String, BlueGreenRole>();
    private final Map<String, Pair<HostSpec, HostSpec>> correspondingNodes = new ConcurrentHashMap<String, Pair<HostSpec, HostSpec>>();

    public BlueGreenStatus(String bgdId, BlueGreenPhase phase) {
        this(bgdId, phase, new ArrayList<ConnectRouting>(), new ArrayList<ExecuteRouting>(), new HashMap<String, BlueGreenRole>(), new HashMap<String, Pair<HostSpec, HostSpec>>());
    }

    public BlueGreenStatus(String bgdId, BlueGreenPhase phase, List<ConnectRouting> connectRouting, List<ExecuteRouting> executeRouting, Map<String, BlueGreenRole> roleByHost, Map<String, Pair<HostSpec, HostSpec>> correspondingNodes) {
        this.bgdId = bgdId;
        this.currentPhase = phase;
        this.unmodifiableConnectRouting = Collections.unmodifiableList(new ArrayList<ConnectRouting>(connectRouting));
        this.unmodifiableExecuteRouting = Collections.unmodifiableList(new ArrayList<ExecuteRouting>(executeRouting));
        this.roleByHost.putAll(roleByHost);
        this.correspondingNodes.putAll(correspondingNodes);
    }

    public @NonNull BlueGreenPhase getCurrentPhase() {
        return this.currentPhase;
    }

    public List<ConnectRouting> getConnectRouting() {
        return this.unmodifiableConnectRouting;
    }

    public List<ExecuteRouting> getExecuteRouting() {
        return this.unmodifiableExecuteRouting;
    }

    public Map<String, BlueGreenRole> getRoleByHost() {
        return this.roleByHost;
    }

    public Map<String, Pair<HostSpec, HostSpec>> getCorrespondingNodes() {
        return this.correspondingNodes;
    }

    public BlueGreenRole getRole(HostSpec hostSpec) {
        return this.roleByHost.get(hostSpec.getHost().toLowerCase());
    }

    public String toString() {
        String roleByHostMap = this.roleByHost.entrySet().stream().map(x -> String.format("%s -> %s", x.getKey(), x.getValue())).collect(Collectors.joining("\n   "));
        String connectRoutingStr = this.unmodifiableConnectRouting.stream().map(Object::toString).collect(Collectors.joining("\n   "));
        String executeRoutingStr = this.unmodifiableExecuteRouting.stream().map(Object::toString).collect(Collectors.joining("\n   "));
        return String.format("%s [\n bgdId: '%s', \n phase: %s, \n Connect routing: \n   %s \n Execute routing: \n   %s \n roleByHost: \n   %s \n]", new Object[]{super.toString(), this.bgdId, this.currentPhase, StringUtils.isNullOrEmpty(connectRoutingStr) ? "-" : connectRoutingStr, StringUtils.isNullOrEmpty(executeRoutingStr) ? "-" : executeRoutingStr, StringUtils.isNullOrEmpty(roleByHostMap) ? "-" : roleByHostMap});
    }
}

