/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ExecutorFactory {
    private static final ConcurrentHashMap<String, ThreadFactory> THREAD_FACTORY_MAP = new ConcurrentHashMap();

    public static ExecutorService newSingleThreadExecutor(String threadName) {
        return Executors.newSingleThreadExecutor(ExecutorFactory.getThreadFactory(threadName));
    }

    public static ExecutorService newCachedThreadPool(String threadName) {
        return Executors.newCachedThreadPool(ExecutorFactory.getThreadFactory(threadName));
    }

    public static ExecutorService newFixedThreadPool(int threadCount, String threadName) {
        return Executors.newFixedThreadPool(threadCount, ExecutorFactory.getThreadFactory(threadName));
    }

    public static ScheduledExecutorService newSingleThreadScheduledThreadExecutor(String threadName) {
        return Executors.newSingleThreadScheduledExecutor(ExecutorFactory.getThreadFactory(threadName));
    }

    private static ThreadFactory getThreadFactory(String threadName) {
        return THREAD_FACTORY_MAP.computeIfAbsent(threadName, ExecutorFactory::createThreadFactory);
    }

    private static ThreadFactory createThreadFactory(String threadName) {
        AtomicLong threadCounter = new AtomicLong();
        return runnable -> {
            String formattedThreadName = String.format("%s %s-%d", "AWS JDBC Driver", threadName, threadCounter.incrementAndGet());
            Thread thread = new Thread(runnable, formattedThreadName);
            thread.setDaemon(true);
            return thread;
        };
    }
}

