/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SynchronousExecutor;

public class LimitlessQueryHelper {
    protected final @NonNull PluginService pluginService;
    protected static final Logger LOGGER = Logger.getLogger(LimitlessQueryHelper.class.getName());
    protected static final Executor networkTimeoutExecutor = new SynchronousExecutor();
    protected static final int DEFAULT_QUERY_TIMEOUT_MS = 5000;

    public LimitlessQueryHelper(@NonNull PluginService pluginService) {
        this.pluginService = pluginService;
    }

    /*
     * Exception decompiling
     */
    public List<HostSpec> queryForLimitlessRouters(Connection conn, int hostPortToMap) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List<HostSpec> mapResultSetToHostSpecList(ResultSet resultSet, int hostPortToMap) throws SQLException {
        ArrayList<HostSpec> hosts = new ArrayList<HostSpec>();
        while (resultSet.next()) {
            HostSpec host = this.createHost(resultSet, hostPortToMap);
            hosts.add(host);
        }
        return hosts;
    }

    protected HostSpec createHost(ResultSet resultSet, int hostPortToMap) throws SQLException {
        String hostName = resultSet.getString(1);
        float cpu = resultSet.getFloat(2);
        long weight = (long)(10.0 - Math.floor(10.0f * cpu));
        if (weight < 1L || weight > 10L) {
            weight = 1L;
            LOGGER.warning(() -> Messages.get("LimitlessRouterMonitor.invalidRouterLoad", new Object[]{hostName, Float.valueOf(cpu)}));
        }
        return this.pluginService.getHostSpecBuilder().host(hostName).port(hostPortToMap).role(HostRole.WRITER).availability(HostAvailability.AVAILABLE).weight(weight).hostId(hostName).build();
    }

    private static /* synthetic */ String lambda$queryForLimitlessRouters$0(SQLException e) {
        return Messages.get("LimitlessRouterMonitor.getNetworkTimeoutError", new Object[]{e.getMessage()});
    }
}

