/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen;

import java.util.HashMap;
import java.util.Map;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;

public enum BlueGreenRole {
    SOURCE(0),
    TARGET(1);

    private static final Map<String, BlueGreenRole> blueGreenRoleMapping_1_0;
    private final int value;

    private BlueGreenRole(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BlueGreenRole parseRole(String value, String version) {
        if ("1.0".equals(version)) {
            if (StringUtils.isNullOrEmpty(value)) {
                throw new IllegalArgumentException(Messages.get("bgd.unknownRole", new Object[]{value}));
            }
            BlueGreenRole role = blueGreenRoleMapping_1_0.get(value.toUpperCase());
            if (role == null) {
                throw new IllegalArgumentException(Messages.get("bgd.unknownRole", new Object[]{value}));
            }
            return role;
        }
        throw new IllegalArgumentException(Messages.get("bgd.unknownVersion", new Object[]{version}));
    }

    static {
        blueGreenRoleMapping_1_0 = new HashMap<String, BlueGreenRole>(){
            {
                this.put("BLUE_GREEN_DEPLOYMENT_SOURCE", SOURCE);
                this.put("BLUE_GREEN_DEPLOYMENT_TARGET", TARGET);
            }
        };
    }
}

