/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.GenericExceptionHandler;
import software.amazon.jdbc.hostlistprovider.ConnectionStringHostListProvider;
import software.amazon.jdbc.plugin.failover.FailoverRestriction;

public class UnknownDialect
implements Dialect {
    private static final List<String> dialectUpdateCandidates = Arrays.asList("aurora-pg", "aurora-mysql", "rds-multi-az-pg-cluster", "rds-multi-az-mysql-cluster", "rds-pg", "rds-mysql", "pg", "mysql", "mariadb");
    private static GenericExceptionHandler genericExceptionHandler;
    private static final EnumSet<FailoverRestriction> NO_RESTRICTIONS;

    @Override
    public int getDefaultPort() {
        return -1;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (genericExceptionHandler == null) {
            genericExceptionHandler = new GenericExceptionHandler();
        }
        return genericExceptionHandler;
    }

    @Override
    public String getHostAliasQuery() {
        return null;
    }

    @Override
    public String getServerVersionQuery() {
        return null;
    }

    @Override
    public boolean isDialect(Connection connection) {
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return dialectUpdateCandidates;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return (properties, initialUrl, servicesContainer) -> new ConnectionStringHostListProvider(properties, initialUrl, servicesContainer.getHostListProviderService());
    }

    @Override
    public void prepareConnectProperties(@NonNull Properties connectProperties, @NonNull String protocol, @NonNull HostSpec hostSpec) {
    }

    @Override
    public EnumSet<FailoverRestriction> getFailoverRestrictions() {
        return NO_RESTRICTIONS;
    }

    static {
        NO_RESTRICTIONS = EnumSet.noneOf(FailoverRestriction.class);
    }
}

