/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen;

import java.util.HashMap;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;

public enum BlueGreenPhase {
    NOT_CREATED(0, false),
    CREATED(1, false),
    PREPARATION(2, true),
    IN_PROGRESS(3, true),
    POST(4, true),
    COMPLETED(5, true);

    private static final HashMap<String, BlueGreenPhase> blueGreenStatusMapping;
    private final int value;
    private final boolean activeSwitchoverOrCompleted;

    private BlueGreenPhase(int value, boolean activeSwitchoverOrCompleted) {
        this.value = value;
        this.activeSwitchoverOrCompleted = activeSwitchoverOrCompleted;
    }

    public static BlueGreenPhase parsePhase(String value, String version) {
        if (StringUtils.isNullOrEmpty(value)) {
            return NOT_CREATED;
        }
        BlueGreenPhase phase = blueGreenStatusMapping.get(value.toUpperCase());
        if (phase == null) {
            throw new IllegalArgumentException(Messages.get("bgd.unknownStatus", new Object[]{value}));
        }
        return phase;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isActiveSwitchoverOrCompleted() {
        return this.activeSwitchoverOrCompleted;
    }

    static {
        blueGreenStatusMapping = new HashMap<String, BlueGreenPhase>(){
            {
                this.put("AVAILABLE", CREATED);
                this.put("SWITCHOVER_INITIATED", PREPARATION);
                this.put("SWITCHOVER_IN_PROGRESS", IN_PROGRESS);
                this.put("SWITCHOVER_IN_POST_PROCESSING", POST);
                this.put("SWITCHOVER_COMPLETED", COMPLETED);
            }
        };
    }
}

