/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;

public class StructWrapper
implements Struct {
    protected Struct struct;
    protected ConnectionPluginManager pluginManager;

    public StructWrapper(@NonNull Struct struct, @NonNull ConnectionPluginManager pluginManager) {
        this.struct = struct;
        this.pluginManager = pluginManager;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STRUCT_GETSQLTYPENAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.struct, JdbcMethod.STRUCT_GETSQLTYPENAME, () -> this.struct.getSQLTypeName(), new Object[0]);
        }
        return this.struct.getSQLTypeName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STRUCT_GETATTRIBUTES)) {
            return WrapperUtils.executeWithPlugins(Object[].class, SQLException.class, this.pluginManager, this.struct, JdbcMethod.STRUCT_GETATTRIBUTES, () -> this.struct.getAttributes(), new Object[0]);
        }
        return this.struct.getAttributes();
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.STRUCT_GETATTRIBUTES)) {
            return WrapperUtils.executeWithPlugins(Object[].class, SQLException.class, this.pluginManager, this.struct, JdbcMethod.STRUCT_GETATTRIBUTES, () -> this.struct.getAttributes(map), map);
        }
        return this.struct.getAttributes(map);
    }

    public String toString() {
        return super.toString() + " - " + this.struct;
    }
}

