/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;

public class SQLDataWrapper
implements SQLData {
    protected SQLData sqlData;
    protected ConnectionPluginManager pluginManager;

    public SQLDataWrapper(@NonNull SQLData sqlData, @NonNull ConnectionPluginManager pluginManager) {
        this.sqlData = sqlData;
        this.pluginManager = pluginManager;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.SQLDATA_GETSQLTYPENAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.sqlData, JdbcMethod.SQLDATA_GETSQLTYPENAME, () -> this.sqlData.getSQLTypeName(), new Object[0]);
        }
        return this.sqlData.getSQLTypeName();
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.SQLDATA_READSQL)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.pluginManager, this.sqlData, JdbcMethod.SQLDATA_READSQL, () -> this.sqlData.readSQL(stream, typeName), stream, typeName);
        } else {
            this.sqlData.readSQL(stream, typeName);
        }
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.SQLDATA_WRITESQL)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.pluginManager, this.sqlData, JdbcMethod.SQLDATA_WRITESQL, () -> this.sqlData.writeSQL(stream), stream);
        } else {
            this.sqlData.writeSQL(stream);
        }
    }

    public String toString() {
        return super.toString() + " - " + this.sqlData;
    }
}

