/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.Ref;
import java.sql.SQLException;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;

public class RefWrapper
implements Ref {
    protected Ref ref;
    protected ConnectionPluginManager pluginManager;

    public RefWrapper(@NonNull Ref ref, @NonNull ConnectionPluginManager pluginManager) {
        this.ref = ref;
        this.pluginManager = pluginManager;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.REF_GETBASETYPENAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.ref, JdbcMethod.REF_GETBASETYPENAME, () -> this.ref.getBaseTypeName(), new Object[0]);
        }
        return this.ref.getBaseTypeName();
    }

    @Override
    public Object getObject(Map<String, Class<?>> map) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.REF_GETOBJECT)) {
            return WrapperUtils.executeWithPlugins(Object.class, SQLException.class, this.pluginManager, this.ref, JdbcMethod.REF_GETOBJECT, () -> this.ref.getObject(map), map);
        }
        return this.ref.getObject(map);
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.REF_GETOBJECT)) {
            return WrapperUtils.executeWithPlugins(Object.class, SQLException.class, this.pluginManager, this.ref, JdbcMethod.REF_GETOBJECT, () -> this.ref.getObject(), new Object[0]);
        }
        return this.ref.getObject();
    }

    @Override
    public void setObject(Object value) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.REF_SETOBJECT)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.pluginManager, this.ref, JdbcMethod.REF_SETOBJECT, () -> this.ref.setObject(value), value);
        } else {
            this.ref.setObject(value);
        }
    }

    public String toString() {
        return super.toString() + " - " + this.ref;
    }
}

