/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.util.WrapperUtils;

public class ArrayWrapper
implements Array {
    protected Array array;
    protected ConnectionPluginManager pluginManager;

    public ArrayWrapper(@NonNull Array array, @NonNull ConnectionPluginManager pluginManager) {
        this.array = array;
        this.pluginManager = pluginManager;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.ARRAY_GETBASETYPENAME)) {
            return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETBASETYPENAME, () -> this.array.getBaseTypeName(), new Object[0]);
        }
        return this.array.getBaseTypeName();
    }

    @Override
    public int getBaseType() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.ARRAY_GETBASETYPE)) {
            return WrapperUtils.executeWithPlugins(Integer.TYPE, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETBASETYPE, () -> this.array.getBaseType(), new Object[0]);
        }
        return this.array.getBaseType();
    }

    @Override
    public Object getArray() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.ARRAY_GETARRAY)) {
            return WrapperUtils.executeWithPlugins(Object.class, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETARRAY, () -> this.array.getArray(), new Object[0]);
        }
        return this.array.getArray();
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.ARRAY_GETARRAY)) {
            return WrapperUtils.executeWithPlugins(Object.class, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETARRAY, () -> this.array.getArray(map), map);
        }
        return this.array.getArray(map);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.ARRAY_GETARRAY)) {
            return WrapperUtils.executeWithPlugins(Object.class, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETARRAY, () -> this.array.getArray(index, count), index, count);
        }
        return this.array.getArray(index, count);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.ARRAY_GETARRAY)) {
            return WrapperUtils.executeWithPlugins(Object.class, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETARRAY, () -> this.array.getArray(index, count, map), index, count, map);
        }
        return this.array.getArray(index, count, map);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETRESULTSET, () -> this.array.getResultSet(), new Object[0]);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETRESULTSET, () -> this.array.getResultSet(map), map);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETRESULTSET, () -> this.array.getResultSet(index, count), index, count);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return WrapperUtils.executeWithPlugins(ResultSet.class, SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_GETRESULTSET, () -> this.array.getResultSet(index, count, map), index, count, map);
    }

    @Override
    public void free() throws SQLException {
        if (this.pluginManager.mustUsePipeline(JdbcMethod.ARRAY_FREE)) {
            WrapperUtils.runWithPlugins(SQLException.class, this.pluginManager, this.array, JdbcMethod.ARRAY_FREE, () -> this.array.free(), new Object[0]);
        } else {
            this.array.free();
        }
    }

    public String toString() {
        return this.array == null ? null : this.array.toString();
    }
}

