/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util.telemetry;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.entities.Entity;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class XRayTelemetryContext
implements TelemetryContext {
    private static final Logger LOGGER = Logger.getLogger(XRayTelemetryContext.class.getName());
    private Entity traceEntity;
    private final String name;

    public XRayTelemetryContext(String name, TelemetryTraceLevel traceLevel) {
        this.name = name;
        Entity parentEntity = AWSXRay.getTraceEntity();
        TelemetryTraceLevel effectiveTraceLevel = traceLevel;
        if (parentEntity == null && traceLevel == TelemetryTraceLevel.NESTED) {
            effectiveTraceLevel = TelemetryTraceLevel.NO_TRACE;
        }
        switch (effectiveTraceLevel) {
            case FORCE_TOP_LEVEL: 
            case TOP_LEVEL: {
                this.traceEntity = AWSXRay.beginSegment((String)name);
                if (parentEntity != null) {
                    this.setAttribute("parentTraceId", parentEntity.getTraceId().toString());
                }
                this.setAttribute("traceName", name);
                LOGGER.finest(() -> String.format("[XRay] Telemetry '%s' trace ID: %s", name, this.traceEntity.getTraceId()));
                break;
            }
            case NESTED: {
                this.traceEntity = AWSXRay.beginSubsegment((String)name);
                this.setAttribute("traceName", name);
                break;
            }
            case NO_TRACE: {
                break;
            }
        }
    }

    public static void postCopy(XRayTelemetryContext telemetryContext, TelemetryTraceLevel traceLevel) {
        if (traceLevel == TelemetryTraceLevel.NO_TRACE) {
            return;
        }
        if (traceLevel == TelemetryTraceLevel.FORCE_TOP_LEVEL || traceLevel == TelemetryTraceLevel.TOP_LEVEL) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                XRayTelemetryContext copy = XRayTelemetryContext.clone(telemetryContext, traceLevel);
                copy.closeContext();
            });
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            XRayTelemetryContext copy = XRayTelemetryContext.clone(telemetryContext, traceLevel);
            copy.closeContext();
        }
    }

    private static XRayTelemetryContext clone(XRayTelemetryContext telemetryContext, TelemetryTraceLevel traceLevel) {
        XRayTelemetryContext copy = new XRayTelemetryContext("copy: " + telemetryContext.getName(), traceLevel);
        copy.traceEntity.setStartTime(telemetryContext.traceEntity.getStartTime());
        copy.traceEntity.setEndTime(telemetryContext.traceEntity.getEndTime());
        Map annotations = telemetryContext.traceEntity.getAnnotations();
        for (Map.Entry entry : annotations.entrySet()) {
            if (entry.getValue() == null || "traceName".equals(entry.getKey())) continue;
            copy.setAttribute((String)entry.getKey(), entry.getValue().toString());
        }
        copy.traceEntity.setError(telemetryContext.traceEntity.isError());
        copy.setAttribute("sourceTraceId", telemetryContext.traceEntity.getTraceId().toString());
        if (telemetryContext.traceEntity.getParent() != null) {
            if (traceLevel == TelemetryTraceLevel.NESTED) {
                copy.traceEntity.setParent(telemetryContext.traceEntity.getParent());
            }
            if (traceLevel == TelemetryTraceLevel.FORCE_TOP_LEVEL || traceLevel == TelemetryTraceLevel.TOP_LEVEL) {
                copy.setAttribute("parentTraceId", telemetryContext.traceEntity.getParent().getTraceId().toString());
            }
        }
        return copy;
    }

    @Override
    public void setSuccess(boolean success) {
        if (this.traceEntity != null) {
            this.traceEntity.setError(!success);
        }
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.traceEntity != null) {
            this.traceEntity.putAnnotation(key, value);
        }
    }

    @Override
    public void setException(Exception exception) {
        if (this.traceEntity != null && exception != null) {
            this.setAttribute("exceptionType", exception.getClass().getSimpleName());
            if (exception.getMessage() != null) {
                this.setAttribute("exceptionMessage", exception.getMessage());
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.traceEntity == null ? "null" : this.traceEntity.getId();
    }

    @Override
    public void closeContext() {
        try {
            if (this.traceEntity != null) {
                this.traceEntity.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

