/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcMethod;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.MariadbDriverHelper;

public class MariadbTargetDriverDialect
extends GenericTargetDriverDialect {
    private static final String PERMIT_MYSQL_SCHEME = "permitMysqlScheme";
    private static final String DRIVER_CLASS_NAME = "org.mariadb.jdbc.Driver";
    private static final String DS_CLASS_NAME = "org.mariadb.jdbc.MariaDbDataSource";
    private static final String CP_DS_CLASS_NAME = "org.mariadb.jdbc.MariaDbPoolDataSource";
    private static final Set<String> MARIADB_ALLOWED_ON_CLOSED_METHOD_NAMES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(GenericTargetDriverDialect.ALLOWED_ON_CLOSED_METHODS);
            this.add(JdbcMethod.CONNECTION_GETCATALOG.methodName);
            this.add(JdbcMethod.CONNECTION_GETMETADATA.methodName);
            this.add(JdbcMethod.CONNECTION_ISREADONLY.methodName);
            this.add(JdbcMethod.CONNECTION_GETSCHEMA.methodName);
            this.add(JdbcMethod.CONNECTION_GETAUTOCOMMIT.methodName);
            this.add(JdbcMethod.CONNECTION_GETHOLDABILITY.methodName);
            this.add(JdbcMethod.CONNECTION_GETCLIENTINFO.methodName);
            this.add(JdbcMethod.CONNECTION_GETNETWORKTIMEOUT.methodName);
            this.add(JdbcMethod.CONNECTION_GETTYPEMAP.methodName);
            this.add(JdbcMethod.CONNECTION_CREATECLOB.methodName);
            this.add(JdbcMethod.CONNECTION_CREATEBLOB.methodName);
            this.add(JdbcMethod.CONNECTION_CREATENCLOB.methodName);
            this.add(JdbcMethod.CONNECTION_CLEARWARNINGS.methodName);
            this.add(JdbcMethod.CONNECTION_SETHOLDABILITY.methodName);
            this.add(JdbcMethod.CONNECTION_SETSCHEMA.methodName);
            this.add(JdbcMethod.STATEMENT_CLEARWARNINGS.methodName);
            this.add(JdbcMethod.STATEMENT_GETFETCHSIZE.methodName);
            this.add(JdbcMethod.STATEMENT_GETMAXFIELDSIZE.methodName);
            this.add(JdbcMethod.STATEMENT_GETRESULTSETTYPE.methodName);
            this.add(JdbcMethod.STATEMENT_ISCLOSEONCOMPLETION.methodName);
            this.add(JdbcMethod.STATEMENT_CLEARBATCH.methodName);
            this.add(JdbcMethod.STATEMENT_CLOSEONCOMPLETION.methodName);
            this.add(JdbcMethod.STATEMENT_GETGENERATEDKEYS.methodName);
            this.add(JdbcMethod.STATEMENT_GETMAXROWS.methodName);
            this.add(JdbcMethod.STATEMENT_GETMORERESULTS.methodName);
            this.add(JdbcMethod.STATEMENT_GETQUERYTIMEOUT.methodName);
            this.add(JdbcMethod.STATEMENT_GETRESULTSET.methodName);
            this.add(JdbcMethod.STATEMENT_GETRESULTSETCONCURRENCY.methodName);
            this.add(JdbcMethod.STATEMENT_GETUPDATECOUNT.methodName);
            this.add(JdbcMethod.STATEMENT_ADDBATCH.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETARRAY.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETBIGDECIMAL.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETBLOB.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETBOOLEAN.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETBYTE.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETBYTES.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETCHARACTERSTREAM.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETCLOB.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETDATE.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETDOUBLE.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETFLOAT.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETINT.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETLONG.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETNCHARACTERSTREAM.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETNCLOB.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETNSTRING.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETOBJECT.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETSHORT.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETTIME.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETSTRING.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETTIMESTAMP.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_GETURL.methodName);
            this.add(JdbcMethod.CALLABLESTATEMENT_WASNULL.methodName);
            this.add(JdbcMethod.PREPAREDSTATEMENT_ADDBATCH.methodName);
            this.add(JdbcMethod.PREPAREDSTATEMENT_CLEARPARAMETERS.methodName);
        }
    });

    @Override
    public boolean isDialect(Driver driver) {
        return DRIVER_CLASS_NAME.equals(driver.getClass().getName());
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return DS_CLASS_NAME.equals(dataSourceClass) || CP_DS_CLASS_NAME.equals(dataSourceClass);
    }

    @Override
    public ConnectInfo prepareConnectInfo(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        boolean permitMysqlSchemeFlag = props.containsKey(PERMIT_MYSQL_SCHEME);
        props.remove(PERMIT_MYSQL_SCHEME);
        PropertyDefinition.removeAllExcept(props, PropertyDefinition.USER.name, PropertyDefinition.PASSWORD.name, PropertyDefinition.TCP_KEEP_ALIVE.name, PropertyDefinition.CONNECT_TIMEOUT.name, PropertyDefinition.SOCKET_TIMEOUT.name);
        String urlBuilder = protocol + hostSpec.getUrl() + databaseName + (permitMysqlSchemeFlag ? "?permitMysqlScheme" : "");
        return new ConnectInfo(urlBuilder, props);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        MariadbDriverHelper helper = new MariadbDriverHelper();
        helper.prepareDataSource(dataSource, protocol, hostSpec, props);
    }

    @Override
    public boolean isDriverRegistered() throws SQLException {
        MariadbDriverHelper helper = new MariadbDriverHelper();
        return helper.isDriverRegistered();
    }

    @Override
    public void registerDriver() throws SQLException {
        MariadbDriverHelper helper = new MariadbDriverHelper();
        helper.registerDriver();
    }

    @Override
    public Set<String> getAllowedOnConnectionMethodNames() {
        return MARIADB_ALLOWED_ON_CLOSED_METHOD_NAMES;
    }
}

