/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider.monitoring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.BlockingHostListProvider;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.hostlistprovider.RdsHostListProvider;
import software.amazon.jdbc.hostlistprovider.monitoring.ClusterTopologyMonitor;
import software.amazon.jdbc.hostlistprovider.monitoring.ClusterTopologyMonitorImpl;
import software.amazon.jdbc.util.FullServicesContainer;

public class MonitoringRdsHostListProvider
extends RdsHostListProvider
implements BlockingHostListProvider,
CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(MonitoringRdsHostListProvider.class.getName());
    public static final AwsWrapperProperty CLUSTER_TOPOLOGY_HIGH_REFRESH_RATE_MS = new AwsWrapperProperty("clusterTopologyHighRefreshRateMs", "100", "Cluster topology high refresh rate in millis.");
    protected final FullServicesContainer servicesContainer;
    protected final PluginService pluginService;
    protected final long highRefreshRateNano;
    protected final String writerTopologyQuery;

    public MonitoringRdsHostListProvider(Properties properties, String originalUrl, FullServicesContainer servicesContainer, String topologyQuery, String nodeIdQuery, String isReaderQuery, String writerTopologyQuery) {
        super(properties, originalUrl, servicesContainer, topologyQuery, nodeIdQuery, isReaderQuery);
        this.servicesContainer = servicesContainer;
        this.pluginService = servicesContainer.getPluginService();
        this.writerTopologyQuery = writerTopologyQuery;
        this.highRefreshRateNano = TimeUnit.MILLISECONDS.toNanos(CLUSTER_TOPOLOGY_HIGH_REFRESH_RATE_MS.getLong(this.properties));
    }

    public static void clearCache() {
        MonitoringRdsHostListProvider.clearAll();
    }

    @Override
    protected void init() throws SQLException {
        super.init();
    }

    protected ClusterTopologyMonitor initMonitor() throws SQLException {
        return this.servicesContainer.getMonitorService().runIfAbsent(ClusterTopologyMonitorImpl.class, this.clusterId, this.servicesContainer.getStorageService(), this.pluginService.getTelemetryFactory(), this.originalUrl, this.pluginService.getDriverProtocol(), this.pluginService.getTargetDriverDialect(), this.pluginService.getDialect(), this.properties, (connectionService, monitorPluginService) -> new ClusterTopologyMonitorImpl(this.clusterId, this.servicesContainer.getStorageService(), connectionService, this.initialHostSpec, this.properties, this.servicesContainer.getHostListProviderService(), this.clusterInstanceTemplate, this.refreshRateNano, this.highRefreshRateNano, this.topologyQuery, this.writerTopologyQuery, this.nodeIdQuery));
    }

    @Override
    protected List<HostSpec> queryForTopology(Connection conn) throws SQLException {
        ClusterTopologyMonitor monitor = this.servicesContainer.getMonitorService().get(ClusterTopologyMonitorImpl.class, this.clusterId);
        if (monitor == null) {
            monitor = this.initMonitor();
        }
        try {
            return monitor.forceRefresh(conn, 5000L);
        }
        catch (TimeoutException ex) {
            return null;
        }
    }

    @Override
    public List<HostSpec> forceRefresh(boolean shouldVerifyWriter, long timeoutMs) throws SQLException, TimeoutException {
        ClusterTopologyMonitor monitor = this.servicesContainer.getMonitorService().get(ClusterTopologyMonitorImpl.class, this.clusterId);
        if (monitor == null) {
            monitor = this.initMonitor();
        }
        assert (monitor != null);
        return monitor.forceRefresh(shouldVerifyWriter, timeoutMs);
    }

    @Override
    public void releaseResources() {
    }

    static {
        PropertyDefinition.registerPluginProperties(MonitoringRdsHostListProvider.class);
    }
}

