/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.HostSpecBuilder;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.hostlistprovider.DynamicHostListProvider;
import software.amazon.jdbc.hostlistprovider.Topology;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.SynchronousExecutor;
import software.amazon.jdbc.util.Utils;

public class RdsHostListProvider
implements DynamicHostListProvider {
    private static final Logger LOGGER = Logger.getLogger(RdsHostListProvider.class.getName());
    public static final AwsWrapperProperty CLUSTER_TOPOLOGY_REFRESH_RATE_MS = new AwsWrapperProperty("clusterTopologyRefreshRateMs", "30000", "Cluster topology refresh rate in millis. The cached topology for the cluster will be invalidated after the specified time, after which it will be updated during the next interaction with the connection.");
    public static final AwsWrapperProperty CLUSTER_ID = new AwsWrapperProperty("clusterId", "1", "A unique identifier for the cluster. Connections with the same cluster id share a cluster topology cache. If unspecified, a cluster id is '1'.");
    public static final AwsWrapperProperty CLUSTER_INSTANCE_HOST_PATTERN = new AwsWrapperProperty("clusterInstanceHostPattern", null, "The cluster instance DNS pattern that will be used to build a complete instance endpoint. A \"?\" character in this pattern should be used as a placeholder for cluster instance names. This pattern is required to be specified for IP address or custom domain connections to AWS RDS clusters. Otherwise, if unspecified, the pattern will be automatically created for AWS RDS clusters.");
    protected static final Executor networkTimeoutExecutor = new SynchronousExecutor();
    protected static final RdsUtils rdsHelper = new RdsUtils();
    protected static final ConnectionUrlParser connectionUrlParser = new ConnectionUrlParser();
    protected static final int defaultTopologyQueryTimeoutMs = 5000;
    protected final FullServicesContainer servicesContainer;
    protected final HostListProviderService hostListProviderService;
    protected final String originalUrl;
    protected final String topologyQuery;
    protected final String nodeIdQuery;
    protected final String isReaderQuery;
    protected RdsUrlType rdsUrlType;
    protected long refreshRateNano;
    protected List<HostSpec> hostList;
    protected List<HostSpec> initialHostList;
    protected HostSpec initialHostSpec;
    protected final ReentrantLock lock;
    protected String clusterId;
    protected HostSpec clusterInstanceTemplate;
    protected volatile boolean isInitialized;
    protected Properties properties;

    public RdsHostListProvider(Properties properties, String originalUrl, FullServicesContainer servicesContainer, String topologyQuery, String nodeIdQuery, String isReaderQuery) {
        this.refreshRateNano = RdsHostListProvider.CLUSTER_TOPOLOGY_REFRESH_RATE_MS.defaultValue != null ? TimeUnit.MILLISECONDS.toNanos(Long.parseLong(RdsHostListProvider.CLUSTER_TOPOLOGY_REFRESH_RATE_MS.defaultValue)) : TimeUnit.MILLISECONDS.toNanos(30000L);
        this.hostList = new ArrayList<HostSpec>();
        this.initialHostList = new ArrayList<HostSpec>();
        this.lock = new ReentrantLock();
        this.isInitialized = false;
        this.properties = properties;
        this.originalUrl = originalUrl;
        this.servicesContainer = servicesContainer;
        this.hostListProviderService = servicesContainer.getHostListProviderService();
        this.topologyQuery = topologyQuery;
        this.nodeIdQuery = nodeIdQuery;
        this.isReaderQuery = isReaderQuery;
    }

    protected void init() throws SQLException {
        if (this.isInitialized) {
            return;
        }
        this.lock.lock();
        try {
            if (this.isInitialized) {
                return;
            }
            this.initialHostList = connectionUrlParser.getHostsFromConnectionUrl(this.originalUrl, false, this.hostListProviderService::getHostSpecBuilder);
            if (this.initialHostList == null || this.initialHostList.isEmpty()) {
                throw new SQLException(Messages.get("RdsHostListProvider.parsedListEmpty", new Object[]{this.originalUrl}));
            }
            this.initialHostSpec = this.initialHostList.get(0);
            this.hostListProviderService.setInitialConnectionHostSpec(this.initialHostSpec);
            this.clusterId = CLUSTER_ID.getString(this.properties);
            this.refreshRateNano = TimeUnit.MILLISECONDS.toNanos(CLUSTER_TOPOLOGY_REFRESH_RATE_MS.getInteger(this.properties));
            HostSpecBuilder hostSpecBuilder = this.hostListProviderService.getHostSpecBuilder();
            String clusterInstancePattern = CLUSTER_INSTANCE_HOST_PATTERN.getString(this.properties);
            this.clusterInstanceTemplate = clusterInstancePattern != null ? ConnectionUrlParser.parseHostPortPair(clusterInstancePattern, () -> hostSpecBuilder) : hostSpecBuilder.host(rdsHelper.getRdsInstanceHostPattern(this.initialHostSpec.getHost())).hostId(this.initialHostSpec.getHostId()).port(this.initialHostSpec.getPort()).build();
            this.validateHostPatternSetting(this.clusterInstanceTemplate.getHost());
            this.rdsUrlType = rdsHelper.identifyRdsType(this.initialHostSpec.getHost());
            this.isInitialized = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected FetchTopologyResult getTopology(Connection conn, boolean forceUpdate) throws SQLException {
        this.init();
        List<HostSpec> storedHosts = this.getStoredTopology();
        if (storedHosts == null || forceUpdate) {
            if (conn == null) {
                return new FetchTopologyResult(false, this.initialHostList);
            }
            List<HostSpec> hosts = this.queryForTopology(conn);
            if (!Utils.isNullOrEmpty(hosts)) {
                this.servicesContainer.getStorageService().set(this.clusterId, new Topology(hosts));
                return new FetchTopologyResult(false, hosts);
            }
        }
        if (storedHosts == null) {
            return new FetchTopologyResult(false, this.initialHostList);
        }
        return new FetchTopologyResult(true, storedHosts);
    }

    /*
     * Exception decompiling
     */
    protected List<HostSpec> queryForTopology(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<HostSpec> processQueryResults(ResultSet resultSet) throws SQLException {
        HashMap<String, HostSpec> hostMap = new HashMap<String, HostSpec>();
        while (resultSet.next()) {
            HostSpec host = this.createHost(resultSet);
            hostMap.put(host.getHost(), host);
        }
        ArrayList<HostSpec> hosts = new ArrayList<HostSpec>();
        ArrayList<HostSpec> writers = new ArrayList<HostSpec>();
        for (HostSpec host : hostMap.values()) {
            if (host.getRole() != HostRole.WRITER) {
                hosts.add(host);
                continue;
            }
            writers.add(host);
        }
        int writerCount = writers.size();
        if (writerCount == 0) {
            LOGGER.severe(() -> Messages.get("RdsHostListProvider.invalidTopology"));
            hosts.clear();
        } else if (writerCount == 1) {
            hosts.add((HostSpec)writers.get(0));
        } else {
            List sortedWriters = writers.stream().sorted(Comparator.comparing(HostSpec::getLastUpdateTime, Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
            hosts.add((HostSpec)sortedWriters.get(0));
        }
        return hosts;
    }

    protected HostSpec createHost(ResultSet resultSet) throws SQLException {
        Timestamp lastUpdateTime;
        String hostName = resultSet.getString(1);
        boolean isWriter = resultSet.getBoolean(2);
        double cpuUtilization = resultSet.getDouble(3);
        double nodeLag = resultSet.getDouble(4);
        try {
            lastUpdateTime = resultSet.getTimestamp(5);
        }
        catch (Exception e) {
            lastUpdateTime = Timestamp.from(Instant.now());
        }
        long weight = Math.round(nodeLag) * 100L + Math.round(cpuUtilization);
        return this.createHost(hostName, isWriter, weight, lastUpdateTime);
    }

    protected HostSpec createHost(String host, boolean isWriter, long weight, Timestamp lastUpdateTime) {
        host = host == null ? "?" : host;
        String endpoint = this.getHostEndpoint(host);
        int port = this.clusterInstanceTemplate.isPortSpecified() ? this.clusterInstanceTemplate.getPort() : this.initialHostSpec.getPort();
        HostSpec hostSpec = this.hostListProviderService.getHostSpecBuilder().host(endpoint).port(port).role(isWriter ? HostRole.WRITER : HostRole.READER).availability(HostAvailability.AVAILABLE).weight(weight).lastUpdateTime(lastUpdateTime).build();
        hostSpec.addAlias(host);
        hostSpec.setHostId(host);
        return hostSpec;
    }

    protected String getHostEndpoint(String nodeName) {
        String host = this.clusterInstanceTemplate.getHost();
        return host.replace("?", nodeName);
    }

    public @Nullable List<HostSpec> getStoredTopology() {
        Topology topology = this.servicesContainer.getStorageService().get(Topology.class, this.clusterId);
        return topology == null ? null : topology.getHosts();
    }

    public static void clearAll() {
    }

    public void clear() {
        this.servicesContainer.getStorageService().remove(Topology.class, this.clusterId);
    }

    @Override
    public List<HostSpec> refresh() throws SQLException {
        return this.refresh(null);
    }

    @Override
    public List<HostSpec> refresh(Connection connection) throws SQLException {
        this.init();
        Connection currentConnection = connection != null ? connection : this.hostListProviderService.getCurrentConnection();
        FetchTopologyResult results = this.getTopology(currentConnection, false);
        LOGGER.finest(() -> Utils.logTopology(results.hosts, results.isCachedData ? "[From cache] Topology:" : null));
        this.hostList = results.hosts;
        return Collections.unmodifiableList(this.hostList);
    }

    @Override
    public List<HostSpec> forceRefresh() throws SQLException {
        return this.forceRefresh(null);
    }

    @Override
    public List<HostSpec> forceRefresh(Connection connection) throws SQLException {
        this.init();
        Connection currentConnection = connection != null ? connection : this.hostListProviderService.getCurrentConnection();
        FetchTopologyResult results = this.getTopology(currentConnection, true);
        LOGGER.finest(() -> Utils.logTopology(results.hosts));
        this.hostList = results.hosts;
        return Collections.unmodifiableList(this.hostList);
    }

    public RdsUrlType getRdsUrlType() throws SQLException {
        this.init();
        return this.rdsUrlType;
    }

    private void validateHostPatternSetting(String hostPattern) {
        if (!rdsHelper.isDnsPatternValid(hostPattern)) {
            String message = Messages.get("RdsHostListProvider.invalidPattern");
            LOGGER.severe(message);
            throw new RuntimeException(message);
        }
        RdsUrlType rdsUrlType = rdsHelper.identifyRdsType(hostPattern);
        if (rdsUrlType == RdsUrlType.RDS_PROXY) {
            String message = Messages.get("RdsHostListProvider.clusterInstanceHostPatternNotSupportedForRDSProxy");
            LOGGER.severe(message);
            throw new RuntimeException(message);
        }
        if (rdsUrlType == RdsUrlType.RDS_CUSTOM_CLUSTER) {
            String message = Messages.get("RdsHostListProvider.clusterInstanceHostPatternNotSupportedForRdsCustom");
            LOGGER.severe(message);
            throw new RuntimeException(message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HostRole getHostRole(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(this.isReaderQuery);){
            if (!rs.next()) throw new SQLException(Messages.get("RdsHostListProvider.errorGettingHostRole"));
            boolean isReader = rs.getBoolean(1);
            HostRole hostRole = isReader ? HostRole.READER : HostRole.WRITER;
            return hostRole;
        }
        catch (SQLException e) {
            throw new SQLException(Messages.get("RdsHostListProvider.errorGettingHostRole"), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HostSpec identifyConnection(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery(this.nodeIdQuery);){
            if (!resultSet.next()) throw new SQLException(Messages.get("RdsHostListProvider.errorIdentifyConnection"));
            String instanceName = resultSet.getString(1);
            List<HostSpec> topology = this.refresh(connection);
            boolean isForcedRefresh = false;
            if (topology == null) {
                topology = this.forceRefresh(connection);
                isForcedRefresh = true;
            }
            if (topology == null) {
                HostSpec hostSpec = null;
                return hostSpec;
            }
            HostSpec foundHost = topology.stream().filter(host -> Objects.equals(instanceName, host.getHostId())).findAny().orElse(null);
            if (foundHost == null && !isForcedRefresh) {
                topology = this.forceRefresh(connection);
                if (topology == null) {
                    HostSpec hostSpec = null;
                    return hostSpec;
                }
                foundHost = topology.stream().filter(host -> Objects.equals(instanceName, host.getHostId())).findAny().orElse(null);
            }
            HostSpec hostSpec = foundHost;
            return hostSpec;
        }
        catch (SQLException e) {
            throw new SQLException(Messages.get("RdsHostListProvider.errorIdentifyConnection"), e);
        }
    }

    @Override
    public String getClusterId() throws UnsupportedOperationException, SQLException {
        this.init();
        return this.clusterId;
    }

    private static /* synthetic */ String lambda$queryForTopology$1(SQLException e) {
        return Messages.get("RdsHostListProvider.errorGettingNetworkTimeout", new Object[]{e.getMessage()});
    }

    static {
        PropertyDefinition.registerPluginProperties(RdsHostListProvider.class);
    }

    protected static class FetchTopologyResult {
        public List<HostSpec> hosts;
        public boolean isCachedData;

        public FetchTopologyResult(boolean isCachedData, List<HostSpec> hosts) {
            this.isCachedData = isCachedData;
            this.hosts = hosts;
        }
    }
}

