/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialectManager;
import software.amazon.jdbc.util.ConnectionUrlParser;
import software.amazon.jdbc.util.Messages;

public class TargetDriverHelper {
    public Driver getTargetDriver(@NonNull String driverUrl, @NonNull Properties props) throws SQLException {
        boolean triedToRegister;
        ConnectionUrlParser parser = new ConnectionUrlParser();
        String protocol = parser.getProtocol(driverUrl);
        TargetDriverDialectManager targetDriverDialectManager = new TargetDriverDialectManager();
        Driver targetDriver = null;
        SQLException lastException = null;
        try {
            targetDriver = DriverManager.getDriver(driverUrl);
        }
        catch (SQLException e) {
            lastException = e;
        }
        if (targetDriver == null && (triedToRegister = targetDriverDialectManager.registerDriver(protocol, props))) {
            try {
                targetDriver = DriverManager.getDriver(driverUrl);
            }
            catch (SQLException e) {
                lastException = e;
            }
        }
        if (targetDriver == null) {
            List registeredDrivers = Collections.list(DriverManager.getDrivers()).stream().map(x -> x.getClass().getName()).collect(Collectors.toList());
            throw new SQLException(Messages.get("Driver.missingDriver", new Object[]{driverUrl, registeredDrivers}), lastException);
        }
        return targetDriver;
    }
}

