/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.ConnectionPluginManager;
import software.amazon.jdbc.util.WrapperUtils;

public class SQLDataWrapper
implements SQLData {
    protected SQLData sqlData;
    protected ConnectionPluginManager pluginManager;

    public SQLDataWrapper(@NonNull SQLData sqlData, @NonNull ConnectionPluginManager pluginManager) {
        this.sqlData = sqlData;
        this.pluginManager = pluginManager;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return WrapperUtils.executeWithPlugins(String.class, SQLException.class, this.pluginManager, this.sqlData, "SQLData.getSQLTypeName", () -> this.sqlData.getSQLTypeName(), new Object[0]);
    }

    @Override
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        WrapperUtils.runWithPlugins(SQLException.class, this.pluginManager, this.sqlData, "SQLData.readSQL", () -> this.sqlData.readSQL(stream, typeName), stream, typeName);
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        WrapperUtils.runWithPlugins(SQLException.class, this.pluginManager, this.sqlData, "SQLData.writeSQL", () -> this.sqlData.writeSQL(stream), stream);
    }

    public String toString() {
        return super.toString() + " - " + this.sqlData;
    }
}

