/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.bluegreen.routing;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenConnectionPlugin;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenPhase;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenRole;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenStatus;
import software.amazon.jdbc.plugin.bluegreen.routing.BaseConnectRouting;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class SuspendConnectRouting
extends BaseConnectRouting {
    private static final Logger LOGGER = Logger.getLogger(SuspendConnectRouting.class.getName());
    private static final String TELEMETRY_SWITCHOVER = "Blue/Green switchover";
    private static final long SLEEP_TIME_MS = 100L;
    protected String bgdId;

    public SuspendConnectRouting(@Nullable String hostAndPort, @Nullable BlueGreenRole role, String bgdId) {
        super(hostAndPort, role);
        this.bgdId = bgdId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection apply(ConnectionPlugin plugin, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc, PluginService pluginService) throws SQLException {
        LOGGER.finest(() -> Messages.get("bgd.inProgressHoldConnect"));
        TelemetryFactory telemetryFactory = pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_SWITCHOVER, TelemetryTraceLevel.NESTED);
        BlueGreenStatus bgStatus = pluginService.getStatus(BlueGreenStatus.class, this.bgdId);
        long timeoutNano = TimeUnit.MILLISECONDS.toNanos(BlueGreenConnectionPlugin.BG_CONNECT_TIMEOUT.getLong(props));
        long holdStartTime = this.getNanoTime();
        long endTime = this.getNanoTime() + timeoutNano;
        try {
            while (this.getNanoTime() <= endTime && bgStatus != null && bgStatus.getCurrentPhase() == BlueGreenPhase.IN_PROGRESS) {
                try {
                    this.delay(100L, bgStatus, pluginService, this.bgdId);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                bgStatus = pluginService.getStatus(BlueGreenStatus.class, this.bgdId);
            }
            if (bgStatus != null && bgStatus.getCurrentPhase() == BlueGreenPhase.IN_PROGRESS) {
                throw new SQLTimeoutException(Messages.get("bgd.inProgressTryConnectLater", new Object[]{BlueGreenConnectionPlugin.BG_CONNECT_TIMEOUT.getLong(props)}));
            }
            LOGGER.finest(Messages.get("bgd.switchoverCompleteContinueWithConnect", new Object[]{TimeUnit.NANOSECONDS.toMillis(this.getNanoTime() - holdStartTime)}));
        }
        finally {
            if (telemetryContext != null) {
                telemetryContext.closeContext();
            }
        }
        return null;
    }
}

