/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.wrapper;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.util.Messages;

public class HighestWeightHostSelector
implements HostSelector {
    public static final String STRATEGY_HIGHEST_WEIGHT = "highestWeight";

    @Override
    public HostSpec getHost(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @Nullable Properties props) throws SQLException {
        List eligibleHosts = hosts.stream().filter(hostSpec -> role.equals((Object)hostSpec.getRole()) && hostSpec.getAvailability().equals((Object)HostAvailability.AVAILABLE)).collect(Collectors.toList());
        if (eligibleHosts.isEmpty()) {
            throw new SQLException(Messages.get("HostSelector.noHostsMatchingRole", new Object[]{role}));
        }
        return eligibleHosts.stream().max(Comparator.comparing(HostSpec::getWeight)).orElseThrow(() -> new SQLException(Messages.get("HostSelector.noHostsMatchingRole", new Object[]{role})));
    }
}

