/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.staledns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.Utils;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class AuroraStaleDnsHelper {
    private static final Logger LOGGER = Logger.getLogger(AuroraStaleDnsHelper.class.getName());
    private final PluginService pluginService;
    private final TelemetryFactory telemetryFactory;
    private final TelemetryCounter staleDNSDetectedCounter;
    private final RdsUtils rdsUtils = new RdsUtils();
    private HostSpec writerHostSpec = null;
    private String writerHostAddress = null;
    private static final int RETRIES = 3;

    public AuroraStaleDnsHelper(PluginService pluginService) {
        this.pluginService = pluginService;
        this.telemetryFactory = pluginService.getTelemetryFactory();
        this.staleDNSDetectedCounter = this.telemetryFactory.createCounter("staleDNS.stale.detected");
    }

    public Connection getVerifiedConnection(boolean isInitialConnection, HostListProviderService hostListProviderService, String driverProtocol, HostSpec hostSpec, Properties props, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        if (!this.rdsUtils.isWriterClusterDns(hostSpec.getHost())) {
            return connectFunc.call();
        }
        Connection conn = connectFunc.call();
        String clusterInetAddress = null;
        try {
            clusterInetAddress = InetAddress.getByName(hostSpec.getHost()).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String hostInetAddress = clusterInetAddress;
        LOGGER.finest(() -> Messages.get("AuroraStaleDnsHelper.clusterEndpointDns", new Object[]{hostInetAddress}));
        if (clusterInetAddress == null) {
            return conn;
        }
        if (this.pluginService.getHostRole(conn) == HostRole.READER) {
            this.pluginService.forceRefreshHostList(conn);
        } else {
            this.pluginService.refreshHostList(conn);
        }
        LOGGER.finest(() -> Utils.logTopology(this.pluginService.getAllHosts()));
        if (this.writerHostSpec == null) {
            HostSpec writerCandidate = this.getWriter();
            if (writerCandidate != null && this.rdsUtils.isRdsClusterDns(writerCandidate.getHost())) {
                return null;
            }
            this.writerHostSpec = writerCandidate;
        }
        LOGGER.finest(() -> Messages.get("AuroraStaleDnsHelper.writerHostSpec", new Object[]{this.writerHostSpec}));
        if (this.writerHostSpec == null) {
            return conn;
        }
        if (this.writerHostAddress == null) {
            try {
                this.writerHostAddress = InetAddress.getByName(this.writerHostSpec.getHost()).getHostAddress();
            }
            catch (UnknownHostException writerCandidate) {
                // empty catch block
            }
        }
        LOGGER.finest(() -> Messages.get("AuroraStaleDnsHelper.writerInetAddress", new Object[]{this.writerHostAddress}));
        if (this.writerHostAddress == null) {
            return conn;
        }
        if (!this.writerHostAddress.equals(clusterInetAddress)) {
            LOGGER.fine(() -> Messages.get("AuroraStaleDnsHelper.staleDnsDetected", new Object[]{this.writerHostSpec}));
            this.staleDNSDetectedCounter.inc();
            List<HostSpec> allowedHosts = this.pluginService.getHosts();
            if (!Utils.containsUrl(allowedHosts, this.writerHostSpec.getUrl())) {
                throw new SQLException(Messages.get("AuroraStaleDnsHelper.currentWriterNotAllowed", new Object[]{this.writerHostSpec == null ? "<null>" : this.writerHostSpec.getUrl(), Utils.logTopology(allowedHosts, "")}));
            }
            Connection writerConn = this.pluginService.connect(this.writerHostSpec, props);
            if (isInitialConnection) {
                hostListProviderService.setInitialConnectionHostSpec(this.writerHostSpec);
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return writerConn;
            }
        }
        return conn;
    }

    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
        if (this.writerHostSpec == null) {
            return;
        }
        for (Map.Entry<String, EnumSet<NodeChangeOptions>> entry : changes.entrySet()) {
            LOGGER.finest(() -> String.format("[%s]: %s", entry.getKey(), entry.getValue()));
            if (!entry.getKey().equals(this.writerHostSpec.getUrl()) || !entry.getValue().contains((Object)NodeChangeOptions.PROMOTED_TO_READER)) continue;
            LOGGER.finest(() -> Messages.get("AuroraStaleDnsHelper.reset"));
            this.writerHostSpec = null;
            this.writerHostAddress = null;
        }
    }

    private HostSpec getWriter() {
        for (HostSpec host : this.pluginService.getAllHosts()) {
            if (host.getRole() != HostRole.WRITER) continue;
            return host;
        }
        return null;
    }
}

