/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import software.amazon.jdbc.plugin.efm.ExecutorServiceInitializer;
import software.amazon.jdbc.plugin.efm.Monitor;
import software.amazon.jdbc.util.Messages;

public class MonitorThreadContainer {
    private static MonitorThreadContainer singleton = null;
    private final Map<String, Monitor> monitorMap = new ConcurrentHashMap<String, Monitor>();
    private final Map<Monitor, Future<?>> tasksMap = new ConcurrentHashMap();
    private final ExecutorService threadPool;
    private static final ReentrantLock LOCK_OBJECT = new ReentrantLock();
    private static final ReentrantLock MONITOR_LOCK_OBJECT = new ReentrantLock();

    public static MonitorThreadContainer getInstance() {
        return MonitorThreadContainer.getInstance(Executors::newCachedThreadPool);
    }

    static MonitorThreadContainer getInstance(ExecutorServiceInitializer executorServiceInitializer) {
        MonitorThreadContainer singletonToReturn = singleton;
        if (singletonToReturn != null) {
            return singletonToReturn;
        }
        LOCK_OBJECT.lock();
        try {
            if (singleton == null) {
                singleton = new MonitorThreadContainer(executorServiceInitializer);
            }
            singletonToReturn = singleton;
        }
        finally {
            LOCK_OBJECT.unlock();
        }
        return singletonToReturn;
    }

    public static void releaseInstance() {
        if (singleton == null) {
            return;
        }
        LOCK_OBJECT.lock();
        try {
            if (singleton != null) {
                singleton.releaseResources();
                singleton = null;
            }
        }
        finally {
            LOCK_OBJECT.unlock();
        }
    }

    private MonitorThreadContainer(ExecutorServiceInitializer executorServiceInitializer) {
        this.threadPool = executorServiceInitializer.createExecutorService();
    }

    public Map<String, Monitor> getMonitorMap() {
        return this.monitorMap;
    }

    public Map<Monitor, Future<?>> getTasksMap() {
        return this.tasksMap;
    }

    Monitor getMonitor(String node) {
        return this.monitorMap.get(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Monitor getOrCreateMonitor(Set<String> nodeKeys, Supplier<Monitor> monitorSupplier) {
        if (nodeKeys.isEmpty()) {
            throw new IllegalArgumentException(Messages.get("MonitorThreadContainer.emptyNodeKeys"));
        }
        MONITOR_LOCK_OBJECT.lock();
        try {
            Monitor monitor = null;
            String anyNodeKey = null;
            for (String nodeKey : nodeKeys) {
                monitor = this.monitorMap.get(nodeKey);
                anyNodeKey = nodeKey;
                if (monitor == null) continue;
                break;
            }
            if (monitor == null) {
                monitor = this.monitorMap.computeIfAbsent(anyNodeKey, k -> {
                    Monitor newMonitor = (Monitor)monitorSupplier.get();
                    this.addTask(newMonitor);
                    return newMonitor;
                });
            }
            this.populateMonitorMap(nodeKeys, monitor);
            Iterator<String> iterator = monitor;
            return iterator;
        }
        finally {
            MONITOR_LOCK_OBJECT.unlock();
        }
    }

    private void populateMonitorMap(Set<String> nodeKeys, Monitor monitor) {
        for (String nodeKey : nodeKeys) {
            this.monitorMap.putIfAbsent(nodeKey, monitor);
        }
    }

    void addTask(Monitor monitor) {
        this.tasksMap.computeIfAbsent(monitor, k -> this.threadPool.submit(monitor));
    }

    public void releaseResource(Monitor monitor) {
        if (monitor == null) {
            return;
        }
        List<Monitor> monitorList = Collections.singletonList(monitor);
        MONITOR_LOCK_OBJECT.lock();
        try {
            this.monitorMap.values().removeAll(monitorList);
            this.tasksMap.computeIfPresent(monitor, (k, v) -> {
                v.cancel(true);
                return null;
            });
        }
        finally {
            MONITOR_LOCK_OBJECT.unlock();
        }
    }

    public void releaseResources() {
        MONITOR_LOCK_OBJECT.lock();
        try {
            this.monitorMap.clear();
            this.tasksMap.values().stream().filter(val -> !val.isDone() && !val.isCancelled()).forEach(val -> val.cancel(true));
            if (this.threadPool != null) {
                this.threadPool.shutdownNow();
            }
        }
        finally {
            MONITOR_LOCK_OBJECT.unlock();
        }
    }
}

