/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.SQLLoginException;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.StringUtils;

public class MySQLExceptionHandler
implements ExceptionHandler {
    public static final String SQLSTATE_ACCESS_ERROR = "28000";
    public static final String SQLSTATE_SYNTAX_ERROR_OR_ACCESS_VIOLATION = "42000";
    public static final String SET_NETWORK_TIMEOUT_ON_CLOSED_CONNECTION = "setNetworkTimeout cannot be called on a closed connection";

    @Override
    public boolean isNetworkException(Throwable throwable) {
        return this.isNetworkException(throwable, null);
    }

    @Override
    public boolean isNetworkException(Throwable throwable, @Nullable TargetDriverDialect targetDriverDialect) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            String sqlState;
            if (exception instanceof SQLException) {
                SQLException sqlException = (SQLException)exception;
                if (!this.isNetworkException(sqlException.getSQLState()) && !this.isHikariMariaDbNetworkException(sqlException)) continue;
                return true;
            }
            if (targetDriverDialect == null || StringUtils.isNullOrEmpty(sqlState = targetDriverDialect.getSQLState(throwable))) continue;
            return this.isNetworkException(sqlState);
        }
        return false;
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return sqlState.startsWith("08");
    }

    @Override
    public boolean isLoginException(Throwable throwable) {
        return this.isLoginException(throwable, null);
    }

    @Override
    public boolean isLoginException(Throwable throwable, @Nullable TargetDriverDialect targetDriverDialect) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (exception instanceof SQLLoginException) {
                return true;
            }
            String sqlState = null;
            if (exception instanceof SQLException) {
                sqlState = ((SQLException)exception).getSQLState();
            } else if (targetDriverDialect != null) {
                sqlState = targetDriverDialect.getSQLState(throwable);
            }
            if (!this.isLoginException(sqlState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoginException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return SQLSTATE_ACCESS_ERROR.equals(sqlState);
    }

    private boolean isHikariMariaDbNetworkException(SQLException sqlException) {
        return sqlException.getSQLState().equals(SQLSTATE_SYNTAX_ERROR_OR_ACCESS_VIOLATION) && sqlException.getMessage().contains(SET_NETWORK_TIMEOUT_ON_CLOSED_CONNECTION);
    }
}

