/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.federatedauth;

import java.security.GeneralSecurityException;
import java.util.Properties;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionPluginFactory;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.federatedauth.CredentialsProviderFactory;
import software.amazon.jdbc.plugin.federatedauth.HttpClientFactory;
import software.amazon.jdbc.plugin.federatedauth.OktaAuthPlugin;
import software.amazon.jdbc.plugin.federatedauth.OktaCredentialsProviderFactory;
import software.amazon.jdbc.util.Messages;

public class OktaAuthPluginFactory
implements ConnectionPluginFactory {
    @Override
    public ConnectionPlugin getInstance(PluginService pluginService, Properties props) {
        return new OktaAuthPlugin(pluginService, this.getCredentialsProviderFactory(pluginService, props));
    }

    private CredentialsProviderFactory getCredentialsProviderFactory(PluginService pluginService, Properties props) {
        return new OktaCredentialsProviderFactory(pluginService, () -> {
            try {
                return new HttpClientFactory().getCloseableHttpClient(OktaAuthPlugin.HTTP_CLIENT_SOCKET_TIMEOUT.getInteger(props), OktaAuthPlugin.HTTP_CLIENT_CONNECT_TIMEOUT.getInteger(props), OktaAuthPlugin.SSL_INSECURE.getBoolean(props));
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(Messages.get("CredentialsProviderFactory.failedToInitializeHttpClient"), e);
            }
        });
    }
}

