/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.failover;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.failover.ClusterAwareReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.FailoverRestriction;
import software.amazon.jdbc.plugin.failover.ReaderFailoverHandler;
import software.amazon.jdbc.plugin.failover.ReaderFailoverResult;
import software.amazon.jdbc.plugin.failover.WriterFailoverHandler;
import software.amazon.jdbc.plugin.failover.WriterFailoverResult;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.Utils;

public class ClusterAwareWriterFailoverHandler
implements WriterFailoverHandler {
    private static final Logger LOGGER = Logger.getLogger(ClusterAwareReaderFailoverHandler.class.getName());
    protected int maxFailoverTimeoutMs = 60000;
    protected int readTopologyIntervalMs = 5000;
    protected int reconnectWriterIntervalMs = 5000;
    protected Properties initialConnectionProps;
    protected PluginService pluginService;
    protected ReaderFailoverHandler readerFailoverHandler;
    private static final WriterFailoverResult DEFAULT_RESULT = new WriterFailoverResult(false, false, null, null, "None");

    public ClusterAwareWriterFailoverHandler(PluginService pluginService, ReaderFailoverHandler readerFailoverHandler, Properties initialConnectionProps) {
        this.pluginService = pluginService;
        this.readerFailoverHandler = readerFailoverHandler;
        this.initialConnectionProps = initialConnectionProps;
    }

    public ClusterAwareWriterFailoverHandler(PluginService pluginService, ReaderFailoverHandler readerFailoverHandler, Properties initialConnectionProps, int failoverTimeoutMs, int readTopologyIntervalMs, int reconnectWriterIntervalMs) {
        this(pluginService, readerFailoverHandler, initialConnectionProps);
        this.maxFailoverTimeoutMs = failoverTimeoutMs;
        this.readTopologyIntervalMs = readTopologyIntervalMs;
        this.reconnectWriterIntervalMs = reconnectWriterIntervalMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriterFailoverResult failover(List<HostSpec> currentTopology) throws SQLException {
        if (Utils.isNullOrEmpty(currentTopology)) {
            LOGGER.severe(() -> Messages.get("ClusterAwareWriterFailoverHandler.failoverCalledWithInvalidTopology"));
            return DEFAULT_RESULT;
        }
        boolean singleTask = this.pluginService.getDialect().getFailoverRestrictions().contains((Object)FailoverRestriction.DISABLE_TASK_A);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        ExecutorCompletionService<WriterFailoverResult> completionService = new ExecutorCompletionService<WriterFailoverResult>(executorService);
        this.submitTasks(currentTopology, executorService, completionService, singleTask);
        try {
            long startTimeNano = System.nanoTime();
            WriterFailoverResult result = this.getNextResult(executorService, completionService, this.maxFailoverTimeoutMs);
            if (result.isConnected() || result.getException() != null || singleTask) {
                WriterFailoverResult writerFailoverResult = result;
                return writerFailoverResult;
            }
            long endTimeNano = System.nanoTime();
            long durationMs = TimeUnit.NANOSECONDS.toMillis(endTimeNano - startTimeNano);
            long remainingTimeMs = (long)this.maxFailoverTimeoutMs - durationMs;
            if (remainingTimeMs > 0L && ((result = this.getNextResult(executorService, completionService, remainingTimeMs)).isConnected() || result.getException() != null)) {
                WriterFailoverResult writerFailoverResult = result;
                return writerFailoverResult;
            }
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.failedToConnectToWriterInstance"));
            WriterFailoverResult writerFailoverResult = DEFAULT_RESULT;
            return writerFailoverResult;
        }
        finally {
            if (!executorService.isTerminated()) {
                executorService.shutdownNow();
            }
        }
    }

    private HostSpec getWriter(List<HostSpec> topology) {
        if (topology == null || topology.isEmpty()) {
            return null;
        }
        for (HostSpec host : topology) {
            if (host.getRole() != HostRole.WRITER) continue;
            return host;
        }
        return null;
    }

    private void submitTasks(List<HostSpec> currentTopology, ExecutorService executorService, CompletionService<WriterFailoverResult> completionService, boolean singleTask) {
        HostSpec writerHost = this.getWriter(currentTopology);
        if (!singleTask) {
            completionService.submit(new ReconnectToWriterHandler(writerHost));
        }
        completionService.submit(new WaitForNewWriterHandler(currentTopology, writerHost));
        executorService.shutdown();
    }

    private WriterFailoverResult getNextResult(ExecutorService executorService, CompletionService<WriterFailoverResult> completionService, long timeoutMs) throws SQLException {
        try {
            Future<WriterFailoverResult> firstCompleted = completionService.poll(timeoutMs, TimeUnit.MILLISECONDS);
            if (firstCompleted == null) {
                return DEFAULT_RESULT;
            }
            WriterFailoverResult result = firstCompleted.get();
            if (result.isConnected()) {
                executorService.shutdownNow();
                this.logTaskSuccess(result);
                return result;
            }
            if (result.getException() != null) {
                executorService.shutdownNow();
                return result;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.createInterruptedException(e);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return DEFAULT_RESULT;
    }

    private void logTaskSuccess(WriterFailoverResult result) {
        String newWriterHost;
        List<HostSpec> topology = result.getTopology();
        if (Utils.isNullOrEmpty(topology)) {
            String taskName = result.getTaskName() == null ? "None" : result.getTaskName();
            LOGGER.severe(() -> Messages.get("ClusterAwareWriterFailoverHandler.successfulConnectionInvalidTopology", new Object[]{taskName}));
            return;
        }
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        HostSpec writerHost = this.getWriter(topology);
        String string = newWriterHost = writerHost == null ? null : writerHost.getUrl();
        if (result.isNewHost()) {
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.successfullyConnectedToNewWriterInstance", new Object[]{newWriterHost}));
        } else {
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.successfullyReconnectedToWriterInstance", new Object[]{newWriterHost}));
        }
    }

    private SQLException createInterruptedException(InterruptedException e) {
        return new SQLException(Messages.get("ClusterAwareWriterFailoverHandler.interruptedThread"), "70100", e);
    }

    private class WaitForNewWriterHandler
    implements Callable<WriterFailoverResult> {
        private Connection currentConnection = null;
        private final HostSpec originalWriterHost;
        private List<HostSpec> currentTopology;
        private HostSpec currentReaderHost;
        private Connection currentReaderConnection;

        public WaitForNewWriterHandler(List<HostSpec> currentTopology, HostSpec currentHost) {
            this.currentTopology = currentTopology;
            this.originalWriterHost = currentHost;
        }

        @Override
        public WriterFailoverResult call() {
            LOGGER.finer(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBAttemptConnectionToNewWriterInstance", new Object[]{PropertyUtils.maskProperties(ClusterAwareWriterFailoverHandler.this.initialConnectionProps)}));
            try {
                boolean success = false;
                while (!success) {
                    this.connectToReader();
                    success = this.refreshTopologyAndConnectToNewWriter();
                    if (success) continue;
                    this.closeReaderConnection();
                }
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(true, true, this.currentTopology, this.currentConnection, "TaskB");
                return writerFailoverResult;
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskB");
                return writerFailoverResult;
            }
            catch (Exception ex) {
                LOGGER.severe(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBEncounteredException", new Object[]{ex.getMessage()}));
                throw ex;
            }
            finally {
                this.performFinalCleanup();
                LOGGER.finer(Messages.get("ClusterAwareWriterFailoverHandler.taskBFinished"));
            }
        }

        private void connectToReader() throws InterruptedException {
            while (true) {
                try {
                    ReaderFailoverResult connResult = ClusterAwareWriterFailoverHandler.this.readerFailoverHandler.getReaderConnection(this.currentTopology);
                    if (this.isValidReaderConnection(connResult)) {
                        this.currentReaderConnection = connResult.getConnection();
                        this.currentReaderHost = connResult.getHost();
                        LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBConnectedToReader", new Object[]{this.currentReaderHost.getUrl()}));
                        break;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBFailedToConnectToAnyReader"));
                TimeUnit.SECONDS.sleep(1L);
            }
        }

        private boolean isValidReaderConnection(ReaderFailoverResult result) {
            return result.isConnected() && result.getConnection() != null && result.getHost() != null;
        }

        private boolean refreshTopologyAndConnectToNewWriter() throws InterruptedException {
            boolean allowOldWriter = ClusterAwareWriterFailoverHandler.this.pluginService.getDialect().getFailoverRestrictions().contains((Object)FailoverRestriction.ENABLE_WRITER_IN_TASK_B);
            while (true) {
                try {
                    ClusterAwareWriterFailoverHandler.this.pluginService.forceRefreshHostList(this.currentReaderConnection);
                    List<HostSpec> topology = ClusterAwareWriterFailoverHandler.this.pluginService.getAllHosts();
                    if (!topology.isEmpty()) {
                        if (topology.size() == 1) {
                            LOGGER.finest(() -> Messages.get("ClusterAwareWriterFailoverHandler.standaloneNode", new Object[]{this.currentReaderHost.getUrl()}));
                        } else {
                            this.currentTopology = topology;
                            HostSpec writerCandidate = ClusterAwareWriterFailoverHandler.this.getWriter(this.currentTopology);
                            if (allowOldWriter || !this.isSame(writerCandidate, this.originalWriterHost)) {
                                LOGGER.finest(() -> Utils.logTopology(this.currentTopology, "[TaskB] Topology:"));
                                if (this.connectToWriter(writerCandidate)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    LOGGER.finer(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBEncounteredException", new Object[]{e}));
                    return false;
                }
                TimeUnit.MILLISECONDS.sleep(ClusterAwareWriterFailoverHandler.this.readTopologyIntervalMs);
            }
        }

        private boolean isSame(HostSpec hostSpec1, HostSpec hostSpec2) {
            if (hostSpec1 == null || hostSpec2 == null) {
                return false;
            }
            return hostSpec1.getUrl().equals(hostSpec2.getUrl());
        }

        private boolean connectToWriter(HostSpec writerCandidate) {
            if (this.isSame(writerCandidate, this.currentReaderHost)) {
                LOGGER.finest(() -> Messages.get("ClusterAwareWriterFailoverHandler.alreadyWriter"));
                this.currentConnection = this.currentReaderConnection;
                return true;
            }
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskBAttemptConnectionToNewWriter", new Object[]{writerCandidate.getUrl()}));
            try {
                this.currentConnection = ClusterAwareWriterFailoverHandler.this.pluginService.forceConnect(writerCandidate, ClusterAwareWriterFailoverHandler.this.initialConnectionProps);
                ClusterAwareWriterFailoverHandler.this.pluginService.setAvailability(writerCandidate.asAliases(), HostAvailability.AVAILABLE);
                return true;
            }
            catch (SQLException exception) {
                ClusterAwareWriterFailoverHandler.this.pluginService.setAvailability(writerCandidate.asAliases(), HostAvailability.NOT_AVAILABLE);
                return false;
            }
        }

        private void closeReaderConnection() {
            try {
                if (this.currentReaderConnection != null && !this.currentReaderConnection.isClosed()) {
                    this.currentReaderConnection.close();
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.currentReaderConnection = null;
                this.currentReaderHost = null;
            }
        }

        private void performFinalCleanup() {
            if (this.currentReaderConnection != null && this.currentConnection != this.currentReaderConnection) {
                try {
                    this.currentReaderConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private class ReconnectToWriterHandler
    implements Callable<WriterFailoverResult> {
        private final HostSpec originalWriterHost;

        public ReconnectToWriterHandler(HostSpec originalWriterHost) {
            this.originalWriterHost = originalWriterHost;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WriterFailoverResult call() {
            LOGGER.fine(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskAAttemptReconnectToWriterInstance", new Object[]{this.originalWriterHost.getUrl(), PropertyUtils.maskProperties(ClusterAwareWriterFailoverHandler.this.initialConnectionProps)}));
            Connection conn = null;
            List<HostSpec> latestTopology = null;
            boolean success = false;
            try {
                while (Utils.isNullOrEmpty(latestTopology)) {
                    block24: {
                        try {
                            if (conn != null && !conn.isClosed()) {
                                conn.close();
                            }
                            conn = ClusterAwareWriterFailoverHandler.this.pluginService.forceConnect(this.originalWriterHost, ClusterAwareWriterFailoverHandler.this.initialConnectionProps);
                            ClusterAwareWriterFailoverHandler.this.pluginService.forceRefreshHostList(conn);
                            latestTopology = ClusterAwareWriterFailoverHandler.this.pluginService.getAllHosts();
                        }
                        catch (SQLException exception) {
                            if (ClusterAwareWriterFailoverHandler.this.pluginService.isNetworkException(exception)) break block24;
                            LOGGER.finer(() -> Messages.get("ClusterAwareWriterFailoverHandler.taskAEncounteredException", new Object[]{exception}));
                            WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskA", exception);
                            try {
                                if (conn != null && !success && !conn.isClosed()) {
                                    conn.close();
                                }
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            LOGGER.finer(Messages.get("ClusterAwareWriterFailoverHandler.taskAFinished"));
                            return writerFailoverResult;
                        }
                    }
                    if (!Utils.isNullOrEmpty(latestTopology)) continue;
                    TimeUnit.MILLISECONDS.sleep(ClusterAwareWriterFailoverHandler.this.reconnectWriterIntervalMs);
                }
                success = this.isCurrentHostWriter(latestTopology);
                LOGGER.finest("[TaskA] success: " + success);
                ClusterAwareWriterFailoverHandler.this.pluginService.setAvailability(this.originalWriterHost.asAliases(), HostAvailability.AVAILABLE);
                WriterFailoverResult exception = new WriterFailoverResult(success, false, latestTopology, success ? conn : null, "TaskA");
                return exception;
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(success, false, latestTopology, success ? conn : null, "TaskA");
                return writerFailoverResult;
            }
            catch (Exception ex) {
                LOGGER.severe(() -> ex.getMessage());
                WriterFailoverResult writerFailoverResult = new WriterFailoverResult(false, false, null, null, "TaskA");
                return writerFailoverResult;
            }
            finally {
                try {
                    if (conn != null && !success && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (Exception exception) {}
                LOGGER.finer(Messages.get("ClusterAwareWriterFailoverHandler.taskAFinished"));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isCurrentHostWriter(List<HostSpec> latestTopology) {
            HostSpec latestWriter = ClusterAwareWriterFailoverHandler.this.getWriter(latestTopology);
            Set<String> latestWriterAllAliases = latestWriter.asAliases();
            Set<String> currentAliases = this.originalWriterHost.asAliases();
            if (currentAliases == null) return false;
            if (!latestWriterAllAliases.stream().anyMatch(currentAliases::contains)) return false;
            return true;
        }
    }
}

