/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.WrapperUtils;

public class LogQueryConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(LogQueryConnectionPlugin.class.getName());
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Statement.executeQuery", "Statement.executeUpdate", "Statement.execute", "PreparedStatement.execute", "PreparedStatement.executeQuery", "PreparedStatement.executeUpdate", "PreparedStatement.executeLargeUpdate", "CallableStatement.execute", "CallableStatement.executeQuery", "CallableStatement.executeUpdate", "CallableStatement.executeLargeUpdate")));
    private static final Set<String> methodWithQueryArg = new HashSet<String>(Arrays.asList("Statement.execute", "Statement.executeQuery", "Statement.executeUpdate", "PreparedStatement.execute", "PreparedStatement.executeQuery", "PreparedStatement.executeUpdate", "CallableStatement.execute", "CallableStatement.executeQuery", "CallableStatement.executeUpdate"));
    private static final Set<String> methodWithNoArg = new HashSet<String>(Arrays.asList("PreparedStatement.execute", "PreparedStatement.executeQuery", "PreparedStatement.executeUpdate", "PreparedStatement.executeLargeUpdate", "CallableStatement.execute", "CallableStatement.executeQuery", "CallableStatement.executeUpdate", "CallableStatement.executeLargeUpdate"));
    private final Map<String, String> queryAccessorByClassName = new HashMap<String, String>(){
        {
            this.put("com.mysql.cj.jdbc.ClientPreparedStatement", "query.originalSql");
            this.put("com.mysql.cj.jdbc.CallableStatement", "query.originalSql");
            this.put("org.postgresql.jdbc.PgPreparedStatement", "preparedQuery.key");
            this.put("org.postgresql.jdbc.PgCallableStatement", "preparedQuery.key.sql");
            this.put("org.mariadb.jdbc.ClientPreparedStatement", "sql");
        }
    };
    public static final AwsWrapperProperty ENHANCED_LOG_QUERY_ENABLED = new AwsWrapperProperty("enhancedLogQueryEnabled", "false", "Allows the 'logQuery' plugin to inspect object internals to get prepared SQL statements and batches.");
    protected final boolean enhancedLogQueryEnabled;

    public LogQueryConnectionPlugin(Properties props) {
        this.enhancedLogQueryEnabled = ENHANCED_LOG_QUERY_ENABLED.getBoolean(props);
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        String sql = this.getQuery(methodInvokeOn, methodName, jdbcMethodArgs);
        if (!StringUtils.isNullOrEmpty(sql)) {
            LOGGER.fine(() -> Messages.get("LogQueryConnectionPlugin.executingQuery", new Object[]{methodName, sql}));
        }
        return jdbcMethodFunc.call();
    }

    protected <T> String getQuery(Object methodInvokeOn, String methodName, Object[] jdbcMethodArgs) {
        String accessor;
        if (methodWithQueryArg.contains(methodName) && jdbcMethodArgs != null && jdbcMethodArgs.length > 0) {
            return jdbcMethodArgs[0] == null ? null : jdbcMethodArgs[0].toString();
        }
        if (!this.enhancedLogQueryEnabled || methodInvokeOn == null) {
            return null;
        }
        String targetClassName = methodInvokeOn.getClass().getName();
        if (methodWithNoArg.contains(methodName) && (jdbcMethodArgs == null || jdbcMethodArgs.length == 0) && (accessor = this.queryAccessorByClassName.get(targetClassName)) != null) {
            Object query = WrapperUtils.getFieldValue(methodInvokeOn, accessor);
            return query == null ? null : query.toString();
        }
        return null;
    }

    static {
        PropertyDefinition.registerPluginProperties(LogQueryConnectionPlugin.class);
    }
}

