/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider.monitoring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.BlockingHostListProvider;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.hostlistprovider.RdsHostListProvider;
import software.amazon.jdbc.hostlistprovider.monitoring.ClusterTopologyMonitor;
import software.amazon.jdbc.hostlistprovider.monitoring.ClusterTopologyMonitorImpl;
import software.amazon.jdbc.util.SlidingExpirationCacheWithCleanupThread;

public class MonitoringRdsHostListProvider
extends RdsHostListProvider
implements BlockingHostListProvider,
CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(MonitoringRdsHostListProvider.class.getName());
    public static final AwsWrapperProperty CLUSTER_TOPOLOGY_HIGH_REFRESH_RATE_MS = new AwsWrapperProperty("clusterTopologyHighRefreshRateMs", "100", "Cluster topology high refresh rate in millis.");
    protected static final long CACHE_CLEANUP_NANO = TimeUnit.MINUTES.toNanos(1L);
    protected static final long MONITOR_EXPIRATION_NANO = TimeUnit.MINUTES.toNanos(15L);
    protected static final long TOPOLOGY_CACHE_EXPIRATION_NANO = TimeUnit.MINUTES.toNanos(5L);
    protected static final SlidingExpirationCacheWithCleanupThread<String, ClusterTopologyMonitor> monitors = new SlidingExpirationCacheWithCleanupThread(ClusterTopologyMonitor::canDispose, monitor -> {
        try {
            monitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }, CACHE_CLEANUP_NANO);
    protected final PluginService pluginService;
    protected final long highRefreshRateNano;
    protected final String writerTopologyQuery;

    public MonitoringRdsHostListProvider(Properties properties, String originalUrl, HostListProviderService hostListProviderService, String topologyQuery, String nodeIdQuery, String isReaderQuery, String writerTopologyQuery, PluginService pluginService) {
        super(properties, originalUrl, hostListProviderService, topologyQuery, nodeIdQuery, isReaderQuery);
        this.pluginService = pluginService;
        this.writerTopologyQuery = writerTopologyQuery;
        this.highRefreshRateNano = TimeUnit.MILLISECONDS.toNanos(CLUSTER_TOPOLOGY_HIGH_REFRESH_RATE_MS.getLong(this.properties));
    }

    @Override
    public void clear() {
        topologyCache.remove(this.clusterId);
    }

    public static void clearCache() {
        monitors.getEntries().values().forEach(monitor -> {
            try {
                monitor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        monitors.clear();
        topologyCache.clear();
        primaryClusterIdCache.clear();
        suggestedPrimaryClusterIdCache.clear();
    }

    @Override
    protected void init() throws SQLException {
        super.init();
    }

    protected ClusterTopologyMonitor initMonitor() {
        return monitors.computeIfAbsent(this.clusterId, key -> new ClusterTopologyMonitorImpl((String)key, topologyCache, this.initialHostSpec, this.properties, this.pluginService, this.hostListProviderService, this.clusterInstanceTemplate, this.refreshRateNano, this.highRefreshRateNano, TOPOLOGY_CACHE_EXPIRATION_NANO, this.topologyQuery, this.writerTopologyQuery, this.nodeIdQuery), MONITOR_EXPIRATION_NANO);
    }

    @Override
    protected List<HostSpec> queryForTopology(Connection conn) throws SQLException {
        ClusterTopologyMonitor monitor = (ClusterTopologyMonitor)monitors.get(this.clusterId, MONITOR_EXPIRATION_NANO);
        if (monitor == null) {
            monitor = this.initMonitor();
        }
        try {
            return monitor.forceRefresh(conn, 5000L);
        }
        catch (TimeoutException ex) {
            return null;
        }
    }

    @Override
    protected void clusterIdChanged(String oldClusterId) {
        List existingHosts;
        ClusterTopologyMonitor existingMonitor = (ClusterTopologyMonitor)monitors.get(oldClusterId, MONITOR_EXPIRATION_NANO);
        if (existingMonitor != null) {
            monitors.computeIfAbsent(this.clusterId, key -> existingMonitor, MONITOR_EXPIRATION_NANO);
            assert (monitors.get(this.clusterId, MONITOR_EXPIRATION_NANO) == existingMonitor);
            existingMonitor.setClusterId(this.clusterId);
            monitors.remove(oldClusterId);
        }
        if ((existingHosts = (List)topologyCache.get(oldClusterId)) != null) {
            topologyCache.put(this.clusterId, existingHosts, TOPOLOGY_CACHE_EXPIRATION_NANO);
        }
    }

    @Override
    public List<HostSpec> forceRefresh(boolean shouldVerifyWriter, long timeoutMs) throws SQLException, TimeoutException {
        ClusterTopologyMonitor monitor = (ClusterTopologyMonitor)monitors.get(this.clusterId, MONITOR_EXPIRATION_NANO);
        if (monitor == null) {
            monitor = this.initMonitor();
        }
        assert (monitor != null);
        return monitor.forceRefresh(shouldVerifyWriter, timeoutMs);
    }

    @Override
    public void releaseResources() {
    }

    static {
        PropertyDefinition.registerPluginProperties(MonitoringRdsHostListProvider.class);
    }
}

