/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.ConnectionProviderManager;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SqlMethodAnalyzer;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public final class DefaultConnectionPlugin
implements ConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(DefaultConnectionPlugin.class.getName());
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("*")));
    private static final SqlMethodAnalyzer sqlMethodAnalyzer = new SqlMethodAnalyzer();
    private final @NonNull ConnectionProvider defaultConnProvider;
    private final @Nullable ConnectionProvider effectiveConnProvider;
    private final ConnectionProviderManager connProviderManager;
    private final PluginService pluginService;
    private final PluginManagerService pluginManagerService;

    public DefaultConnectionPlugin(PluginService pluginService, ConnectionProvider defaultConnProvider, @Nullable ConnectionProvider effectiveConnProvider, PluginManagerService pluginManagerService) {
        this(pluginService, defaultConnProvider, effectiveConnProvider, pluginManagerService, new ConnectionProviderManager(defaultConnProvider));
    }

    public DefaultConnectionPlugin(PluginService pluginService, ConnectionProvider defaultConnProvider, @Nullable ConnectionProvider effectiveConnProvider, PluginManagerService pluginManagerService, ConnectionProviderManager connProviderManager) {
        if (pluginService == null) {
            throw new IllegalArgumentException("pluginService");
        }
        if (pluginManagerService == null) {
            throw new IllegalArgumentException("pluginManagerService");
        }
        if (defaultConnProvider == null) {
            throw new IllegalArgumentException("connectionProvider");
        }
        this.pluginService = pluginService;
        this.pluginManagerService = pluginManagerService;
        this.defaultConnProvider = defaultConnProvider;
        this.effectiveConnProvider = effectiveConnProvider;
        this.connProviderManager = connProviderManager;
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        Boolean autocommit;
        T result;
        LOGGER.finest(() -> Messages.get("DefaultConnectionPlugin.executingMethod", new Object[]{methodName}));
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(this.pluginService.getTargetName(), TelemetryTraceLevel.NESTED);
        try {
            result = jdbcMethodFunc.call();
        }
        finally {
            telemetryContext.closeContext();
        }
        Connection currentConn = this.pluginService.getCurrentConnection();
        Connection boundConnection = WrapperUtils.getConnectionFromSqlObject(methodInvokeOn);
        if (boundConnection != null && boundConnection != currentConn) {
            return result;
        }
        if (sqlMethodAnalyzer.doesOpenTransaction(currentConn, methodName, jdbcMethodArgs)) {
            this.pluginManagerService.setInTransaction(true);
        } else if (sqlMethodAnalyzer.doesCloseTransaction(currentConn, methodName, jdbcMethodArgs) || sqlMethodAnalyzer.doesSwitchAutoCommitFalseTrue(currentConn, methodName, jdbcMethodArgs)) {
            this.pluginManagerService.setInTransaction(false);
        }
        if (sqlMethodAnalyzer.isStatementSettingAutoCommit(methodName, jdbcMethodArgs) && (autocommit = sqlMethodAnalyzer.getAutoCommitValueFromSqlStatement(jdbcMethodArgs)) != null) {
            try {
                currentConn.setAutoCommit(autocommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        ConnectionProvider connProvider = null;
        if (this.effectiveConnProvider != null && this.effectiveConnProvider.acceptsUrl(driverProtocol, hostSpec, props)) {
            connProvider = this.effectiveConnProvider;
        }
        if (connProvider == null) {
            connProvider = this.connProviderManager.getConnectionProvider(driverProtocol, hostSpec, props);
        }
        return this.connectInternal(driverProtocol, hostSpec, props, connProvider, isInitialConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection connectInternal(String driverProtocol, HostSpec hostSpec, Properties props, ConnectionProvider connProvider, boolean isInitialConnection) throws SQLException {
        Connection conn;
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(connProvider.getTargetName(), TelemetryTraceLevel.NESTED);
        try {
            conn = connProvider.connect(driverProtocol, this.pluginService.getDialect(), this.pluginService.getTargetDriverDialect(), hostSpec, props);
        }
        finally {
            telemetryContext.closeContext();
        }
        this.connProviderManager.initConnection(conn, driverProtocol, hostSpec, props);
        this.pluginService.setAvailability(hostSpec.asAliases(), HostAvailability.AVAILABLE);
        if (isInitialConnection) {
            this.pluginService.updateDialect(conn);
        }
        return conn;
    }

    @Override
    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        return this.connectInternal(driverProtocol, hostSpec, props, this.defaultConnProvider, isInitialConnection);
    }

    @Override
    public boolean acceptsStrategy(HostRole role, String strategy) {
        if (HostRole.UNKNOWN.equals((Object)role)) {
            return false;
        }
        if (this.effectiveConnProvider != null) {
            return this.effectiveConnProvider.acceptsStrategy(role, strategy);
        }
        return this.connProviderManager.acceptsStrategy(role, strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(HostRole role, String strategy) throws SQLException {
        List<HostSpec> hosts = this.pluginService.getHosts();
        return this.getHostSpecByStrategy(hosts, role, strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(List<HostSpec> hosts, HostRole role, String strategy) throws SQLException {
        if (HostRole.UNKNOWN.equals((Object)role)) {
            throw new SQLException("DefaultConnectionPlugin.unknownRoleRequested");
        }
        if (hosts.isEmpty()) {
            throw new SQLException(Messages.get("DefaultConnectionPlugin.noHostsAvailable"));
        }
        if (this.effectiveConnProvider != null) {
            return this.effectiveConnProvider.getHostSpecByStrategy(hosts, role, strategy, this.pluginService.getProperties());
        }
        return this.connProviderManager.getHostSpecByStrategy(hosts, role, strategy, this.pluginService.getProperties());
    }

    @Override
    public void initHostProvider(String driverProtocol, String initialUrl, Properties props, HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc) throws SQLException {
    }

    @Override
    public OldConnectionSuggestedAction notifyConnectionChanged(EnumSet<NodeChangeOptions> changes) {
        return OldConnectionSuggestedAction.NO_OPINION;
    }

    @Override
    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
    }

    List<String> parseMultiStatementQueries(String query) {
        if (query == null || query.isEmpty()) {
            return new ArrayList<String>();
        }
        if ((query = query.replaceAll("\\s+", " ")).trim().isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.stream(query.split(";")).collect(Collectors.toList());
    }
}

