/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostavailability;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Properties;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.hostavailability.HostAvailabilityStrategy;
import software.amazon.jdbc.hostavailability.HostAvailabilityStrategyFactory;
import software.amazon.jdbc.util.Messages;

public class ExponentialBackoffHostAvailabilityStrategy
implements HostAvailabilityStrategy {
    public static String NAME = "exponentialBackoff";
    private int maxRetries = 5;
    private int initialBackoffTimeSeconds = 30;
    private int notAvailableCount = 0;
    private Timestamp lastChanged;

    public ExponentialBackoffHostAvailabilityStrategy(Properties props) {
        if (HostAvailabilityStrategyFactory.HOST_AVAILABILITY_STRATEGY_MAX_RETRIES.getInteger(props) < 1) {
            throw new IllegalArgumentException(Messages.get("HostAvailabilityStrategy.invalidMaxRetries", new Object[]{HostAvailabilityStrategyFactory.HOST_AVAILABILITY_STRATEGY_MAX_RETRIES.getInteger(props)}));
        }
        this.maxRetries = HostAvailabilityStrategyFactory.HOST_AVAILABILITY_STRATEGY_MAX_RETRIES.getInteger(props);
        if (HostAvailabilityStrategyFactory.HOST_AVAILABILITY_STRATEGY_INITIAL_BACKOFF_TIME.getInteger(props) < 1) {
            throw new IllegalArgumentException(Messages.get("HostAvailabilityStrategy.invalidInitialBackoffTime", new Object[]{HostAvailabilityStrategyFactory.HOST_AVAILABILITY_STRATEGY_INITIAL_BACKOFF_TIME.getInteger(props)}));
        }
        this.initialBackoffTimeSeconds = HostAvailabilityStrategyFactory.HOST_AVAILABILITY_STRATEGY_INITIAL_BACKOFF_TIME.getInteger(props);
        this.lastChanged = Timestamp.from(Instant.now());
    }

    @Override
    public void setHostAvailability(HostAvailability hostAvailability) {
        this.lastChanged = Timestamp.from(Instant.now());
        this.notAvailableCount = hostAvailability == HostAvailability.AVAILABLE ? 0 : ++this.notAvailableCount;
    }

    @Override
    public HostAvailability getHostAvailability(HostAvailability rawHostAvailability) {
        Timestamp now;
        if (rawHostAvailability == HostAvailability.AVAILABLE) {
            return HostAvailability.AVAILABLE;
        }
        if (this.notAvailableCount >= this.maxRetries) {
            return HostAvailability.NOT_AVAILABLE;
        }
        double retryDelayMillis = Math.pow(2.0, this.notAvailableCount) * (double)this.initialBackoffTimeSeconds * 1000.0;
        Timestamp earliestRetry = new Timestamp(this.lastChanged.getTime() + Math.round(retryDelayMillis));
        if (earliestRetry.before(now = Timestamp.from(Instant.now()))) {
            return HostAvailability.AVAILABLE;
        }
        return rawHostAvailability;
    }
}

