/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.util.Properties;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.awssdk.regions.Region;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.StringUtils;

public class RegionUtils {
    protected static final RdsUtils rdsUtils = new RdsUtils();

    public @Nullable Region getRegion(String host, Properties props, String propKey) {
        Region region = this.getRegion(props, propKey);
        return region != null ? region : this.getRegionFromHost(host);
    }

    public @Nullable Region getRegion(Properties props, String propKey) {
        String regionString = props.getProperty(propKey);
        if (StringUtils.isNullOrEmpty(regionString)) {
            return null;
        }
        return this.getRegionFromRegionString(regionString);
    }

    public Region getRegionFromRegionString(String regionString) {
        Region region = Region.of((String)regionString);
        if (!Region.regions().contains(region)) {
            throw new RuntimeException(Messages.get("AwsSdk.unsupportedRegion", new Object[]{regionString}));
        }
        return region;
    }

    public Region getRegionFromHost(String host) {
        String regionString = rdsUtils.getRdsRegion(host);
        if (StringUtils.isNullOrEmpty(regionString)) {
            return null;
        }
        return this.getRegionFromRegionString(regionString);
    }
}

