/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.GenericTargetDriverDialect;
import software.amazon.jdbc.targetdriverdialect.MariadbDriverHelper;

public class MariadbTargetDriverDialect
extends GenericTargetDriverDialect {
    private static final String PERMIT_MYSQL_SCHEME = "permitMysqlScheme";
    private static final String DRIVER_CLASS_NAME = "org.mariadb.jdbc.Driver";
    private static final String DS_CLASS_NAME = "org.mariadb.jdbc.MariaDbDataSource";
    private static final String CP_DS_CLASS_NAME = "org.mariadb.jdbc.MariaDbPoolDataSource";

    @Override
    public boolean isDialect(Driver driver) {
        return DRIVER_CLASS_NAME.equals(driver.getClass().getName());
    }

    @Override
    public boolean isDialect(String dataSourceClass) {
        return DS_CLASS_NAME.equals(dataSourceClass) || CP_DS_CLASS_NAME.equals(dataSourceClass);
    }

    @Override
    public ConnectInfo prepareConnectInfo(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        String databaseName = PropertyDefinition.DATABASE.getString(props) != null ? PropertyDefinition.DATABASE.getString(props) : "";
        boolean permitMysqlSchemeFlag = props.containsKey(PERMIT_MYSQL_SCHEME);
        props.remove(PERMIT_MYSQL_SCHEME);
        PropertyDefinition.removeAllExcept(props, PropertyDefinition.USER.name, PropertyDefinition.PASSWORD.name, PropertyDefinition.TCP_KEEP_ALIVE.name, PropertyDefinition.CONNECT_TIMEOUT.name, PropertyDefinition.SOCKET_TIMEOUT.name);
        String urlBuilder = protocol + hostSpec.getUrl() + databaseName + (permitMysqlSchemeFlag ? "?permitMysqlScheme" : "");
        return new ConnectInfo(urlBuilder, props);
    }

    @Override
    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        MariadbDriverHelper helper = new MariadbDriverHelper();
        helper.prepareDataSource(dataSource, protocol, hostSpec, props);
    }

    @Override
    public boolean isDriverRegistered() throws SQLException {
        MariadbDriverHelper helper = new MariadbDriverHelper();
        return helper.isDriverRegistered();
    }

    @Override
    public void registerDriver() throws SQLException {
        MariadbDriverHelper helper = new MariadbDriverHelper();
        helper.registerDriver();
    }

    @Override
    public Set<String> getAllowedOnConnectionMethodNames() {
        return Collections.unmodifiableSet(new HashSet<String>(){
            {
                this.addAll(GenericTargetDriverDialect.ALLOWED_ON_CLOSED_METHODS);
                this.add("Connection.getCatalog");
                this.add("Connection.getMetaData");
                this.add("Connection.isReadOnly");
                this.add("Connection.getSchema");
                this.add("Connection.getAutoCommit");
                this.add("Connection.getHoldability");
                this.add("Connection.getClientInfo");
                this.add("Connection.getNetworkTimeout");
                this.add("Connection.getTypeMap");
                this.add("Connection.createClob");
                this.add("Connection.createBlob");
                this.add("Connection.createNClob");
                this.add("Connection.clearWarnings");
                this.add("Connection.setHoldability");
                this.add("Connection.setSchema");
                this.add("Statement.clearWarnings");
                this.add("Statement.getFetchSize");
                this.add("Statement.getMaxFieldSize");
                this.add("Statement.getResultSetType");
                this.add("Statement.isCloseOnCompletion");
                this.add("Statement.clearBatch");
                this.add("Statement.closeOnCompletion");
                this.add("Statement.getGeneratedKeys");
                this.add("Statement.getMaxRows");
                this.add("Statement.getMoreResults");
                this.add("Statement.getQueryTimeout");
                this.add("Statement.getResultSet");
                this.add("Statement.getResultSetConcurrency");
                this.add("Statement.getUpdateCount");
                this.add("Statement.addBatch");
                this.add("CallableStatement.getArray");
                this.add("CallableStatement.getBigDecimal");
                this.add("CallableStatement.getBlob");
                this.add("CallableStatement.getBoolean");
                this.add("CallableStatement.getByte");
                this.add("CallableStatement.getBytes");
                this.add("CallableStatement.getCharacterStream");
                this.add("CallableStatement.getClob");
                this.add("CallableStatement.getDate");
                this.add("CallableStatement.getDouble");
                this.add("CallableStatement.getFloat");
                this.add("CallableStatement.getInt");
                this.add("CallableStatement.getLong");
                this.add("CallableStatement.getNCharacterStream");
                this.add("CallableStatement.getNClob");
                this.add("CallableStatement.getNString");
                this.add("CallableStatement.getObject");
                this.add("CallableStatement.getShort");
                this.add("CallableStatement.getTime");
                this.add("CallableStatement.getString");
                this.add("CallableStatement.getTimestamp");
                this.add("CallableStatement.getURL");
                this.add("CallableStatement.wasNull");
                this.add("PreparedStatement.addBatch");
                this.add("PreparedStatement.clearParameters");
            }
        });
    }
}

