/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.limitless.LimitlessQueryHelper;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterMonitor;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterMonitorInitializer;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterService;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SlidingExpirationCacheWithCleanupThread;
import software.amazon.jdbc.util.Utils;

public class LimitlessRouterServiceImpl
implements LimitlessRouterService {
    private static final Logger LOGGER = Logger.getLogger(LimitlessRouterServiceImpl.class.getName());
    public static final AwsWrapperProperty MONITOR_DISPOSAL_TIME_MS = new AwsWrapperProperty("limitlessTransactionRouterMonitorDisposalTimeMs", "600000", "Interval in milliseconds for an Limitless router monitor to be considered inactive and to be disposed.");
    protected static final long CACHE_CLEANUP_NANO = TimeUnit.MINUTES.toNanos(1L);
    protected static final Map<String, ReentrantLock> forceGetLimitlessRoutersLockMap = new ConcurrentHashMap<String, ReentrantLock>();
    protected final PluginService pluginService;
    protected final LimitlessQueryHelper queryHelper;
    protected final LimitlessRouterMonitorInitializer limitlessRouterMonitorInitializer;
    protected static final SlidingExpirationCacheWithCleanupThread<String, LimitlessRouterMonitor> limitlessRouterMonitors = new SlidingExpirationCacheWithCleanupThread(limitlessRouterMonitor -> true, limitlessRouterMonitor -> {
        try {
            limitlessRouterMonitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }, CACHE_CLEANUP_NANO);
    protected static final SlidingExpirationCacheWithCleanupThread<String, List<HostSpec>> limitlessRouterCache = new SlidingExpirationCacheWithCleanupThread(x -> true, x -> {}, CACHE_CLEANUP_NANO);

    public LimitlessRouterServiceImpl(@NonNull PluginService pluginService) {
        this(pluginService, (hostSpec, routerCache, routerCacheKey, props, intervalMs) -> new LimitlessRouterMonitor(pluginService, hostSpec, routerCache, routerCacheKey, props, intervalMs), new LimitlessQueryHelper(pluginService));
    }

    public LimitlessRouterServiceImpl(@NonNull PluginService pluginService, LimitlessRouterMonitorInitializer limitlessRouterMonitorInitializer, LimitlessQueryHelper queryHelper) {
        this.pluginService = pluginService;
        this.limitlessRouterMonitorInitializer = limitlessRouterMonitorInitializer;
        this.queryHelper = queryHelper;
    }

    @Override
    public List<HostSpec> getLimitlessRouters(String clusterId, Properties props) throws SQLException {
        long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props));
        return (List)limitlessRouterCache.get(clusterId, cacheExpirationNano);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HostSpec> forceGetLimitlessRoutersWithConn(Connection connection, int hostPort, Properties props) throws SQLException {
        long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props));
        ReentrantLock lock = forceGetLimitlessRoutersLockMap.computeIfAbsent(this.pluginService.getHostListProvider().getClusterId(), key -> new ReentrantLock());
        lock.lock();
        try {
            List limitlessRouters = (List)limitlessRouterCache.get(this.pluginService.getHostListProvider().getClusterId(), cacheExpirationNano);
            if (!Utils.isNullOrEmpty(limitlessRouters)) {
                List list = limitlessRouters;
                return list;
            }
            List<HostSpec> newLimitlessRouters = this.queryHelper.queryForLimitlessRouters(connection, hostPort);
            limitlessRouterCache.put(this.pluginService.getHostListProvider().getClusterId(), newLimitlessRouters, MONITOR_DISPOSAL_TIME_MS.getLong(props));
            List<HostSpec> list = newLimitlessRouters;
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void startMonitoring(@NonNull HostSpec hostSpec, @NonNull Properties props, int intervalMs) {
        try {
            String limitlessRouterMonitorKey = this.pluginService.getHostListProvider().getClusterId();
            long cacheExpirationNano = TimeUnit.MILLISECONDS.toNanos(MONITOR_DISPOSAL_TIME_MS.getLong(props));
            limitlessRouterMonitors.computeIfAbsent(limitlessRouterMonitorKey, key -> this.limitlessRouterMonitorInitializer.createLimitlessRouterMonitor(hostSpec, limitlessRouterCache, limitlessRouterMonitorKey, props, intervalMs), cacheExpirationNano);
        }
        catch (SQLException e) {
            LOGGER.warning(Messages.get("LimitlessRouterServiceImpl.errorStartingMonitor", new Object[]{e}));
            throw new RuntimeException(e);
        }
    }
}

