/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.AcceptsUrlFunc;
import software.amazon.jdbc.DataSourceConnectionProvider;
import software.amazon.jdbc.HikariPoolConfigurator;
import software.amazon.jdbc.HikariPoolMapping;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSelector;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.HostSpecBuilder;
import software.amazon.jdbc.LeastConnectionsHostSelector;
import software.amazon.jdbc.PooledConnectionProvider;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.RandomHostSelector;
import software.amazon.jdbc.RoundRobinHostSelector;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.targetdriverdialect.ConnectInfo;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.RdsUrlType;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.SlidingExpirationCache;
import software.amazon.jdbc.wrapper.HighestWeightHostSelector;

public class HikariPooledConnectionProvider
implements PooledConnectionProvider,
CanReleaseResources {
    private static final String thisClassName = HikariPooledConnectionProvider.class.getName();
    private static final Logger LOGGER = Logger.getLogger(HikariPooledConnectionProvider.class.getName());
    protected static final Map<String, HostSelector> acceptedStrategies = Collections.unmodifiableMap(new HashMap<String, HostSelector>(){
        {
            this.put("highestWeight", new HighestWeightHostSelector());
            this.put("random", new RandomHostSelector());
            this.put("roundRobin", new RoundRobinHostSelector());
        }
    });
    protected static final RdsUtils rdsUtils = new RdsUtils();
    protected static SlidingExpirationCache<PoolKey, HikariDataSource> databasePools = new SlidingExpirationCache(hikariDataSource -> hikariDataSource.getHikariPoolMXBean().getActiveConnections() == 0, HikariDataSource::close);
    protected static long poolExpirationCheckNanos = TimeUnit.MINUTES.toNanos(30L);
    protected final HikariPoolConfigurator poolConfigurator;
    protected final HikariPoolMapping poolMapping;
    protected final AcceptsUrlFunc acceptsUrlFunc;
    protected final LeastConnectionsHostSelector leastConnectionsHostSelector;

    public HikariPooledConnectionProvider(HikariPoolConfigurator hikariPoolConfigurator) {
        this(hikariPoolConfigurator, null);
    }

    public HikariPooledConnectionProvider(HikariPoolConfigurator hikariPoolConfigurator, HikariPoolMapping mapping) {
        this.poolConfigurator = hikariPoolConfigurator;
        this.poolMapping = mapping;
        this.acceptsUrlFunc = null;
        this.leastConnectionsHostSelector = new LeastConnectionsHostSelector(databasePools);
    }

    public HikariPooledConnectionProvider(HikariPoolConfigurator hikariPoolConfigurator, HikariPoolMapping mapping, long poolExpirationNanos, long poolCleanupNanos) {
        this.poolConfigurator = hikariPoolConfigurator;
        this.poolMapping = mapping;
        this.acceptsUrlFunc = null;
        poolExpirationCheckNanos = poolExpirationNanos;
        databasePools.setCleanupIntervalNanos(poolCleanupNanos);
        this.leastConnectionsHostSelector = new LeastConnectionsHostSelector(databasePools);
    }

    public HikariPooledConnectionProvider(HikariPoolConfigurator hikariPoolConfigurator, HikariPoolMapping mapping, AcceptsUrlFunc acceptsUrlFunc, long poolExpirationNanos, long poolCleanupNanos) {
        this.poolConfigurator = hikariPoolConfigurator;
        this.poolMapping = mapping;
        this.acceptsUrlFunc = acceptsUrlFunc;
        poolExpirationCheckNanos = poolExpirationNanos;
        databasePools.setCleanupIntervalNanos(poolCleanupNanos);
        this.leastConnectionsHostSelector = new LeastConnectionsHostSelector(databasePools);
    }

    @Override
    public boolean acceptsUrl(@NonNull String protocol, @NonNull HostSpec hostSpec, @NonNull Properties props) {
        if (this.acceptsUrlFunc != null) {
            return this.acceptsUrlFunc.acceptsUrl(hostSpec, props);
        }
        RdsUrlType urlType = rdsUtils.identifyRdsType(hostSpec.getHost());
        return RdsUrlType.RDS_INSTANCE.equals((Object)urlType);
    }

    @Override
    public boolean acceptsStrategy(@NonNull HostRole role, @NonNull String strategy) {
        return acceptedStrategies.containsKey(strategy) || "leastConnections".equals(strategy);
    }

    @Override
    public HostSpec getHostSpecByStrategy(@NonNull List<HostSpec> hosts, @NonNull HostRole role, @NonNull String strategy, @Nullable Properties props) throws SQLException {
        if (!this.acceptsStrategy(role, strategy)) {
            throw new UnsupportedOperationException(Messages.get("ConnectionProvider.unsupportedHostSpecSelectorStrategy", new Object[]{strategy, DataSourceConnectionProvider.class}));
        }
        if ("leastConnections".equals(strategy)) {
            return this.leastConnectionsHostSelector.getHost(hosts, role, props);
        }
        return acceptedStrategies.get(strategy).getHost(hosts, role, props);
    }

    @Override
    public Connection connect(@NonNull String protocol, @NonNull Dialect dialect, @NonNull TargetDriverDialect targetDriverDialect, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        Properties copy = PropertyUtils.copyProperties(props);
        HostSpec connectionHostSpec = hostSpec;
        if (PropertyDefinition.ENABLE_GREEN_NODE_REPLACEMENT.getBoolean(props) && rdsUtils.isRdsDns(hostSpec.getHost()) && rdsUtils.isGreenInstance(hostSpec.getHost())) {
            InetAddress resolvedAddress = null;
            try {
                resolvedAddress = InetAddress.getByName(hostSpec.getHost());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (resolvedAddress == null) {
                String fixedHost = rdsUtils.removeGreenInstancePrefix(hostSpec.getHost());
                connectionHostSpec = new HostSpecBuilder(hostSpec.getHostAvailabilityStrategy()).copyFrom(hostSpec).host(fixedHost).build();
            }
        }
        HostSpec finalHostSpec = connectionHostSpec;
        dialect.prepareConnectProperties(copy, protocol, finalHostSpec);
        HikariDataSource ds = databasePools.computeIfAbsent(new PoolKey(hostSpec.getUrl(), this.getPoolKey(finalHostSpec, copy)), lambdaPoolKey -> this.createHikariDataSource(protocol, finalHostSpec, copy, targetDriverDialect), poolExpirationCheckNanos);
        ds.setPassword(copy.getProperty(PropertyDefinition.PASSWORD.name));
        return ds.getConnection();
    }

    protected String getPoolKey(HostSpec hostSpec, Properties props) {
        if (this.poolMapping != null) {
            return this.poolMapping.getKey(hostSpec, props);
        }
        String user = props.getProperty(PropertyDefinition.USER.name);
        return user == null ? "" : user;
    }

    @Override
    public void releaseResources() {
        databasePools.getEntries().forEach((poolKey, pool) -> {
            if (!pool.isClosed()) {
                pool.close();
            }
        });
        databasePools.clear();
    }

    public static void clearCache() {
        databasePools.getEntries().forEach((poolKey, pool) -> {
            if (!pool.isClosed()) {
                pool.close();
            }
        });
        databasePools.clear();
    }

    protected void configurePool(HikariConfig config, String protocol, HostSpec hostSpec, Properties connectionProps, @NonNull TargetDriverDialect targetDriverDialect) {
        ConnectInfo connectInfo;
        Properties copy = PropertyUtils.copyProperties(connectionProps);
        try {
            connectInfo = targetDriverDialect.prepareConnectInfo(protocol, hostSpec, copy);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        StringBuilder urlBuilder = new StringBuilder(connectInfo.url);
        StringJoiner propsJoiner = new StringJoiner("&");
        connectInfo.props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (!PropertyDefinition.PASSWORD.name.equals(k) && !PropertyDefinition.USER.name.equals(k)) {
                propsJoiner.add(k + "=" + v);
            }
        }));
        if (connectInfo.url.contains("?")) {
            urlBuilder.append("&").append(propsJoiner);
        } else {
            urlBuilder.append("?").append(propsJoiner);
        }
        config.setJdbcUrl(urlBuilder.toString());
        String user = connectInfo.props.getProperty(PropertyDefinition.USER.name);
        String password = connectInfo.props.getProperty(PropertyDefinition.PASSWORD.name);
        if (user != null) {
            config.setUsername(user);
        }
        if (password != null) {
            config.setPassword(password);
        }
    }

    public int getHostCount() {
        return databasePools.size();
    }

    public Set<String> getHosts() {
        return Collections.unmodifiableSet(databasePools.getEntries().keySet().stream().map(poolKey -> ((PoolKey)poolKey).url).collect(Collectors.toSet()));
    }

    public Set<PoolKey> getKeys() {
        return databasePools.getEntries().keySet();
    }

    @Override
    public String getTargetName() {
        return thisClassName;
    }

    public void logConnections() {
        LOGGER.finest(() -> {
            StringBuilder builder = new StringBuilder();
            databasePools.getEntries().forEach((key, dataSource) -> {
                builder.append("\t[ ");
                builder.append(key).append(":");
                builder.append("\n\t {");
                builder.append("\n\t\t").append(dataSource);
                builder.append("\n\t }\n");
                builder.append("\t");
            });
            return String.format("Hikari Pooled Connection: \n[\n%s\n]", builder);
        });
    }

    HikariDataSource createHikariDataSource(String protocol, HostSpec hostSpec, Properties props, @NonNull TargetDriverDialect targetDriverDialect) {
        HikariConfig config = this.poolConfigurator.configurePool(hostSpec, props);
        this.configurePool(config, protocol, hostSpec, props, targetDriverDialect);
        return new HikariDataSource(config);
    }

    void setDatabasePools(SlidingExpirationCache<PoolKey, HikariDataSource> connectionPools) {
        databasePools = connectionPools;
    }

    public static class PoolKey {
        private final @NonNull String url;
        private final @NonNull String extraKey;

        public PoolKey(@NonNull String url, @NonNull String extraKey) {
            this.url = url;
            this.extraKey = extraKey;
        }

        public String getUrl() {
            return this.url;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode()) + (this.extraKey == null ? 0 : this.extraKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PoolKey other = (PoolKey)obj;
            return this.url.equals(other.url) && this.extraKey.equals(other.extraKey);
        }

        public String toString() {
            return "PoolKey [url=" + this.url + ", extraKey=" + this.extraKey + "]";
        }
    }
}

