/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.StringUtils;

public class ConnectionUrlBuilder {
    public static String buildUrl(@NonNull String jdbcProtocol, @NonNull String serverName, int port, @Nullable String databaseName) throws SQLException {
        if (StringUtils.isNullOrEmpty(jdbcProtocol) || StringUtils.isNullOrEmpty(serverName)) {
            throw new SQLException(Messages.get("ConnectionUrlBuilder.missingJdbcProtocol"));
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(jdbcProtocol);
        if (!jdbcProtocol.endsWith("//")) {
            urlBuilder.append("//");
        }
        urlBuilder.append(serverName);
        if (port > 0) {
            urlBuilder.append(":").append(port);
        }
        urlBuilder.append("/");
        if (!StringUtils.isNullOrEmpty(databaseName)) {
            urlBuilder.append(databaseName);
        }
        return urlBuilder.toString();
    }

    public static String buildUrl(String jdbcProtocol, HostSpec hostSpec, Properties props) throws SQLException {
        if (StringUtils.isNullOrEmpty(jdbcProtocol) || hostSpec == null) {
            throw new SQLException(Messages.get("ConnectionUrlBuilder.missingJdbcProtocol"));
        }
        Properties copy = PropertyUtils.copyProperties(props);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(jdbcProtocol);
        if (!jdbcProtocol.endsWith("//")) {
            urlBuilder.append("//");
        }
        urlBuilder.append(hostSpec.getUrl());
        if (!StringUtils.isNullOrEmpty(PropertyDefinition.DATABASE.getString(copy))) {
            urlBuilder.append(PropertyDefinition.DATABASE.getString(copy));
            copy.remove(PropertyDefinition.DATABASE.name);
        }
        StringBuilder queryBuilder = new StringBuilder();
        Enumeration<?> propertyNames = copy.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = propertyNames.nextElement().toString();
            if (propertyName == null || propertyName.trim().equals("")) continue;
            if (queryBuilder.length() != 0) {
                queryBuilder.append("&");
            }
            String propertyValue = copy.getProperty(propertyName);
            try {
                queryBuilder.append(propertyName).append("=").append(URLEncoder.encode(propertyValue, StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(Messages.get("ConnectionUrlBuilder.failureEncodingConnectionUrl"), e);
            }
        }
        if (queryBuilder.length() != 0) {
            urlBuilder.append("?").append((CharSequence)queryBuilder);
        }
        return urlBuilder.toString();
    }
}

