/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.efm.ExecutorServiceInitializer;
import software.amazon.jdbc.plugin.efm.Monitor;
import software.amazon.jdbc.plugin.efm.MonitorConnectionContext;
import software.amazon.jdbc.plugin.efm.MonitorImpl;
import software.amazon.jdbc.plugin.efm.MonitorInitializer;
import software.amazon.jdbc.plugin.efm.MonitorService;
import software.amazon.jdbc.plugin.efm.MonitorThreadContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class MonitorServiceImpl
implements MonitorService {
    private static final Logger LOGGER = Logger.getLogger(MonitorServiceImpl.class.getName());
    public static final AwsWrapperProperty MONITOR_DISPOSAL_TIME_MS = new AwsWrapperProperty("monitorDisposalTime", "600000", "Interval in milliseconds for a monitor to be considered inactive and to be disposed.");
    private final PluginService pluginService;
    private MonitorThreadContainer threadContainer;
    final MonitorInitializer monitorInitializer;
    private Set<String> cachedMonitorNodeKeys = null;
    private WeakReference<Monitor> cachedMonitor = null;
    final TelemetryFactory telemetryFactory;
    final TelemetryCounter abortedConnectionsCounter;

    public MonitorServiceImpl(@NonNull PluginService pluginService) {
        this(pluginService, (hostSpec, properties, monitorService) -> new MonitorImpl(pluginService, hostSpec, properties, MONITOR_DISPOSAL_TIME_MS.getLong(properties), monitorService), () -> Executors.newCachedThreadPool(r -> {
            Thread monitoringThread = new Thread(r);
            monitoringThread.setDaemon(true);
            return monitoringThread;
        }));
    }

    MonitorServiceImpl(PluginService pluginService, MonitorInitializer monitorInitializer, ExecutorServiceInitializer executorServiceInitializer) {
        this.pluginService = pluginService;
        this.telemetryFactory = pluginService.getTelemetryFactory();
        this.abortedConnectionsCounter = this.telemetryFactory.createCounter("efm.connections.aborted");
        this.monitorInitializer = monitorInitializer;
        this.threadContainer = MonitorThreadContainer.getInstance(executorServiceInitializer);
    }

    @Override
    public MonitorConnectionContext startMonitoring(Connection connectionToAbort, Set<String> nodeKeys, HostSpec hostSpec, Properties properties, int failureDetectionTimeMillis, int failureDetectionIntervalMillis, int failureDetectionCount) {
        Monitor monitor;
        if (nodeKeys.isEmpty()) {
            throw new IllegalArgumentException(Messages.get("MonitorServiceImpl.emptyAliasSet", new Object[]{hostSpec}));
        }
        Monitor monitor2 = monitor = this.cachedMonitor == null ? null : (Monitor)this.cachedMonitor.get();
        if (monitor == null || monitor.isStopped() || this.cachedMonitorNodeKeys == null || !this.cachedMonitorNodeKeys.equals(nodeKeys)) {
            monitor = this.getMonitor(nodeKeys, hostSpec, properties);
            this.cachedMonitor = new WeakReference<Monitor>(monitor);
            this.cachedMonitorNodeKeys = Collections.unmodifiableSet(nodeKeys);
        }
        MonitorConnectionContext context = new MonitorConnectionContext(monitor, connectionToAbort, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount, this.abortedConnectionsCounter);
        monitor.startMonitoring(context);
        return context;
    }

    @Override
    public void stopMonitoring(@NonNull MonitorConnectionContext context) {
        Monitor monitor = context.getMonitor();
        monitor.stopMonitoring(context);
    }

    @Override
    public void stopMonitoringForAllConnections(@NonNull Set<String> nodeKeys) {
        for (String nodeKey : nodeKeys) {
            Monitor monitor = this.threadContainer.getMonitor(nodeKey);
            if (monitor == null) continue;
            monitor.clearContexts();
            return;
        }
    }

    @Override
    public void releaseResources() {
        this.threadContainer = null;
    }

    protected Monitor getMonitor(Set<String> nodeKeys, HostSpec hostSpec, Properties properties) {
        return this.threadContainer.getOrCreateMonitor(nodeKeys, () -> this.monitorInitializer.createMonitor(hostSpec, properties, this.threadContainer));
    }

    MonitorThreadContainer getThreadContainer() {
        return this.threadContainer;
    }
}

