/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.limitless;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostRole;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.RoundRobinHostSelector;
import software.amazon.jdbc.hostavailability.HostAvailability;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterService;
import software.amazon.jdbc.plugin.limitless.LimitlessRouterServiceImpl;
import software.amazon.jdbc.util.Messages;

public class LimitlessConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(LimitlessConnectionPlugin.class.getName());
    public static final AwsWrapperProperty WAIT_F0R_ROUTER_INFO = new AwsWrapperProperty("limitlessWaitForTransactionRouterInfo", "true", "If the cache of transaction router info is empty and a new connection is made, this property toggles whether the plugin will wait and synchronously fetch transaction router info before selecting a transaction router to connect to, or to fall back to using the provided DB Shard Group endpoint URL.");
    public static final AwsWrapperProperty GET_ROUTER_RETRY_INTERVAL_MILLIS = new AwsWrapperProperty("limitlessGetTransactionRouterInfoRetryIntervalMs", "300", "Interval in millis between retries fetching Limitless Transaction Router information.");
    public static final AwsWrapperProperty GET_ROUTER_MAX_RETRIES = new AwsWrapperProperty("limitlessGetTransactionRouterInfoMaxRetries", "5", "Max number of connection retries fetching Limitless Transaction Router information.");
    public static final AwsWrapperProperty INTERVAL_MILLIS = new AwsWrapperProperty("limitlessTransactionRouterMonitorIntervalMs", "15000", "Interval in millis between polling for Limitless Transaction Routers to the database.");
    public static final AwsWrapperProperty MAX_RETRIES = new AwsWrapperProperty("limitlessConnectMaxRetries", "5", "Max number of connection retries the Limitless Connection Plugin will attempt.");
    protected final PluginService pluginService;
    protected final @NonNull Properties properties;
    private final @NonNull Supplier<LimitlessRouterService> limitlessRouterServiceSupplier;
    private LimitlessRouterService limitlessRouterService;
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("connect");
            this.add("forceConnect");
        }
    });

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    public LimitlessConnectionPlugin(PluginService pluginService, @NonNull Properties properties) {
        this(pluginService, properties, LimitlessRouterServiceImpl::new);
    }

    public LimitlessConnectionPlugin(PluginService pluginService, @NonNull Properties properties, @NonNull Supplier<LimitlessRouterService> limitlessRouterServiceSupplier) {
        this.pluginService = pluginService;
        this.properties = properties;
        this.limitlessRouterServiceSupplier = limitlessRouterServiceSupplier;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        return this.connectInternal(driverProtocol, hostSpec, props, isInitialConnection, connectFunc);
    }

    @Override
    public Connection forceConnect(@NonNull String driverProtocol, @NonNull HostSpec hostSpec, @NonNull Properties props, boolean isInitialConnection, @NonNull JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        return this.connectInternal(driverProtocol, hostSpec, props, isInitialConnection, forceConnectFunc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Connection connectInternal(@NonNull String driverProtocol, @NonNull HostSpec hostSpec, @NonNull Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        HostSpec selectedHostSpec;
        List<HostSpec> limitlessRouters;
        this.initLimitlessRouterMonitorService();
        if (isInitialConnection) {
            this.limitlessRouterService.startMonitoring(this.pluginService, hostSpec, this.properties, INTERVAL_MILLIS.getInteger(this.properties));
        }
        if ((limitlessRouters = this.limitlessRouterService.getLimitlessRouters(this.pluginService.getHostListProvider().getClusterId(), props)).isEmpty()) {
            LOGGER.finest(Messages.get("LimitlessConnectionPlugin.limitlessRouterCacheEmpty"));
            boolean waitForRouterInfo = WAIT_F0R_ROUTER_INFO.getBoolean(props);
            if (!waitForRouterInfo) {
                LOGGER.finest(Messages.get("LimitlessConnectionPlugin.usingProvidedConnectUrl"));
                return connectFunc.call();
            }
            limitlessRouters = this.synchronouslyGetLimitlessRoutersWithRetry(props);
        } else if (limitlessRouters.contains(hostSpec)) {
            LOGGER.finest(Messages.get("LimitlessConnectionPlugin.connectWithHost", new Object[]{hostSpec.getHost()}));
            return connectFunc.call();
        }
        RoundRobinHostSelector.setRoundRobinHostWeightPairsProperty(props, limitlessRouters);
        try {
            selectedHostSpec = this.pluginService.getHostSpecByStrategy(limitlessRouters, HostRole.WRITER, "roundRobin");
            LOGGER.fine(Messages.get("LimitlessConnectionPlugin.selectedHost", new Object[]{selectedHostSpec.getHost()}));
        }
        catch (UnsupportedOperationException e) {
            LOGGER.severe(Messages.get("LimitlessConnectionPlugin.incorrectConfiguration"));
            throw e;
        }
        try {
            return this.pluginService.connect(selectedHostSpec, props);
        }
        catch (SQLException e) {
            LOGGER.fine(Messages.get("LimitlessConnectionPlugin.failedToConnectToHost", new Object[]{selectedHostSpec.getHost()}));
            selectedHostSpec.setAvailability(HostAvailability.NOT_AVAILABLE);
            return this.retryConnectWithLeastLoadedRouters(limitlessRouters, props, e);
        }
    }

    private void initLimitlessRouterMonitorService() {
        if (this.limitlessRouterService == null) {
            this.limitlessRouterService = this.limitlessRouterServiceSupplier.get();
        }
    }

    private Connection retryConnectWithLeastLoadedRouters(List<HostSpec> limitlessRouters, Properties props, SQLException originalException) throws SQLException {
        List<HostSpec> currentRouters = limitlessRouters;
        int retryCount = 0;
        int maxRetries = MAX_RETRIES.getInteger(props);
        while (retryCount++ < maxRetries) {
            HostSpec selectedHostSpec;
            if (!(currentRouters.stream().anyMatch(h -> h.getAvailability().equals((Object)HostAvailability.AVAILABLE)) || (currentRouters = this.synchronouslyGetLimitlessRoutersWithRetry(props)) != null && !currentRouters.isEmpty() && currentRouters.stream().anyMatch(h -> h.getAvailability().equals((Object)HostAvailability.AVAILABLE)))) {
                throw new SQLException(Messages.get("LimitlessConnectionPlugin.noRoutersAvailableForRetry"), originalException);
            }
            try {
                selectedHostSpec = this.pluginService.getHostSpecByStrategy(limitlessRouters, HostRole.WRITER, "highestWeight");
                LOGGER.finest(Messages.get("LimitlessConnectionPlugin.selectedHostForRetry", new Object[]{selectedHostSpec.getHost()}));
            }
            catch (UnsupportedOperationException e) {
                LOGGER.severe(Messages.get("LimitlessConnectionPlugin.incorrectConfiguration"));
                throw e;
            }
            try {
                return this.pluginService.connect(selectedHostSpec, props);
            }
            catch (SQLException e) {
                selectedHostSpec.setAvailability(HostAvailability.NOT_AVAILABLE);
                LOGGER.finest(Messages.get("LimitlessConnectionPlugin.failedToConnectToHost", new Object[]{selectedHostSpec.getHost()}));
            }
        }
        throw new SQLException(Messages.get("LimitlessConnectionPlugin.noRoutersAvailableForRetry"), originalException);
    }

    private List<HostSpec> synchronouslyGetLimitlessRoutersWithRetry(Properties props) throws SQLException {
        LOGGER.finest(Messages.get("LimitlessConnectionPlugin.synchronouslyGetLimitlessRouters"));
        int retryCount = -1;
        int maxRetries = GET_ROUTER_MAX_RETRIES.getInteger(props);
        int retryIntervalMs = GET_ROUTER_RETRY_INTERVAL_MILLIS.getInteger(props);
        List<HostSpec> newLimitlessRouters = null;
        do {
            try {
                newLimitlessRouters = this.limitlessRouterService.forceGetLimitlessRouters(this.pluginService.getHostListProvider().getClusterId(), props);
                if (newLimitlessRouters != null && !newLimitlessRouters.isEmpty()) {
                    List<HostSpec> list = newLimitlessRouters;
                    return list;
                }
                Thread.sleep(retryIntervalMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(Messages.get("LimitlessConnectionPlugin.interruptedThread"));
            }
            finally {
                ++retryCount;
            }
        } while (retryCount < maxRetries);
        throw new SQLException(Messages.get("LimitlessConnectionPlugin.noRoutersAvailable"));
    }

    static {
        PropertyDefinition.registerPluginProperties(LimitlessConnectionPlugin.class);
    }
}

