/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.dialect.Dialect;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.MySQLExceptionHandler;
import software.amazon.jdbc.hostlistprovider.ConnectionStringHostListProvider;
import software.amazon.jdbc.plugin.failover.FailoverRestriction;

public class MysqlDialect
implements Dialect {
    private static final List<String> dialectUpdateCandidates = Arrays.asList("rds-multi-az-mysql-cluster", "aurora-mysql", "rds-mysql");
    private static MySQLExceptionHandler mySQLExceptionHandler;
    private static final EnumSet<FailoverRestriction> NO_RESTRICTIONS;

    @Override
    public int getDefaultPort() {
        return 3306;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (mySQLExceptionHandler == null) {
            mySQLExceptionHandler = new MySQLExceptionHandler();
        }
        return mySQLExceptionHandler;
    }

    @Override
    public String getHostAliasQuery() {
        return "SELECT CONCAT(@@hostname, ':', @@port)";
    }

    @Override
    public String getServerVersionQuery() {
        return "SHOW VARIABLES LIKE 'version_comment'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDialect(Connection connection) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(this.getServerVersionQuery());
            while (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnValue = rs.getString(i);
                    if (columnValue == null || !columnValue.toLowerCase().contains("mysql")) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return false;
    }

    @Override
    public List<String> getDialectUpdateCandidates() {
        return dialectUpdateCandidates;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return ConnectionStringHostListProvider::new;
    }

    @Override
    public void prepareConnectProperties(@NonNull Properties connectProperties, @NonNull String protocol, @NonNull HostSpec hostSpec) {
    }

    @Override
    public EnumSet<FailoverRestriction> getFailoverRestrictions() {
        return NO_RESTRICTIONS;
    }

    static {
        NO_RESTRICTIONS = EnumSet.noneOf(FailoverRestriction.class);
    }
}

