/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.SQLLoginException;

public class GenericExceptionHandler
implements ExceptionHandler {
    static final List<String> ACCESS_ERRORS = Arrays.asList("28000", "28P01");
    static final List<String> NETWORK_ERRORS = Arrays.asList("53", "57P01", "57P02", "57P03", "58", "99", "F0", "XX", "08");

    @Override
    public boolean isNetworkException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (!(exception instanceof SQLException)) continue;
            return this.isNetworkException(((SQLException)exception).getSQLState());
        }
        return false;
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        for (String errors : NETWORK_ERRORS) {
            if (!sqlState.startsWith(errors)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoginException(Throwable throwable) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (exception instanceof SQLLoginException) {
                return true;
            }
            if (!(exception instanceof SQLException)) continue;
            return this.isLoginException(((SQLException)exception).getSQLState());
        }
        return false;
    }

    @Override
    public boolean isLoginException(String sqlState) {
        return ACCESS_ERRORS.contains(sqlState);
    }
}

