/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import software.amazon.jdbc.util.SlidingExpirationCache;

public class SlidingExpirationCacheWithCleanupThread<K, V>
extends SlidingExpirationCache<K, V> {
    private static final Logger LOGGER = Logger.getLogger(SlidingExpirationCacheWithCleanupThread.class.getName());
    protected static final ExecutorService cleanupThreadPool = Executors.newFixedThreadPool(1, runnableTarget -> {
        Thread monitoringThread = new Thread(runnableTarget);
        monitoringThread.setDaemon(true);
        return monitoringThread;
    });

    public SlidingExpirationCacheWithCleanupThread() {
        this.initCleanupThread();
    }

    public SlidingExpirationCacheWithCleanupThread(SlidingExpirationCache.ShouldDisposeFunc<V> shouldDisposeFunc, SlidingExpirationCache.ItemDisposalFunc<V> itemDisposalFunc) {
        super(shouldDisposeFunc, itemDisposalFunc);
        this.initCleanupThread();
    }

    public SlidingExpirationCacheWithCleanupThread(SlidingExpirationCache.ShouldDisposeFunc<V> shouldDisposeFunc, SlidingExpirationCache.ItemDisposalFunc<V> itemDisposalFunc, long cleanupIntervalNanos) {
        super(shouldDisposeFunc, itemDisposalFunc, cleanupIntervalNanos);
        this.initCleanupThread();
    }

    protected void initCleanupThread() {
        cleanupThreadPool.submit(() -> {
            while (true) {
                TimeUnit.NANOSECONDS.sleep(this.cleanupIntervalNanos);
                LOGGER.finest("Cleaning up...");
                this.cleanupTimeNanos.set(System.nanoTime() + this.cleanupIntervalNanos);
                this.cache.forEach((key, value) -> {
                    try {
                        this.removeIfExpired(key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        });
        cleanupThreadPool.shutdown();
    }

    @Override
    protected void cleanUp() {
    }
}

