/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.targetdriverdialect;

import com.mysql.cj.jdbc.Driver;
import com.mysql.cj.jdbc.MysqlDataSource;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;

public class MysqlConnectorJDriverHelper {
    private static final Logger LOGGER = Logger.getLogger(MysqlConnectorJDriverHelper.class.getName());

    public void prepareDataSource(@NonNull DataSource dataSource, @NonNull HostSpec hostSpec, @NonNull Properties props) throws SQLException {
        Integer loginTimeout;
        if (!(dataSource instanceof MysqlDataSource)) {
            throw new SQLException(Messages.get("TargetDriverDialectManager.unexpectedClass", new Object[]{"com.mysql.cj.jdbc.MysqlDataSource", dataSource.getClass().getName()}));
        }
        MysqlDataSource baseDataSource = (MysqlDataSource)dataSource;
        baseDataSource.setDatabaseName(PropertyDefinition.DATABASE.getString(props));
        baseDataSource.setUser(PropertyDefinition.USER.getString(props));
        baseDataSource.setPassword(PropertyDefinition.PASSWORD.getString(props));
        baseDataSource.setServerName(hostSpec.getHost());
        if (hostSpec.isPortSpecified()) {
            baseDataSource.setPortNumber(hostSpec.getPort());
        }
        if ((loginTimeout = PropertyUtils.getIntegerPropertyValue(props, PropertyDefinition.LOGIN_TIMEOUT)) != null) {
            baseDataSource.setLoginTimeout((int)TimeUnit.MILLISECONDS.toSeconds(loginTimeout.intValue()));
        }
        PropertyDefinition.removeAllExcept(props, PropertyDefinition.USER.name, PropertyDefinition.PASSWORD.name, PropertyDefinition.TCP_KEEP_ALIVE.name, PropertyDefinition.SOCKET_TIMEOUT.name, PropertyDefinition.CONNECT_TIMEOUT.name);
        PropertyUtils.applyProperties(dataSource, props);
    }

    public boolean isDriverRegistered() throws SQLException {
        return Collections.list(DriverManager.getDrivers()).stream().filter(x -> x instanceof Driver).map(x -> true).findAny().orElse(false);
    }

    public void registerDriver() throws SQLException {
        try {
            DriverManager.registerDriver((java.sql.Driver)new Driver());
        }
        catch (SQLException e) {
            throw new SQLException(Messages.get("MysqlConnectorJDriverHelper.canNotRegister"), e);
        }
    }
}

